% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sas.cmprsk.R
\name{sas.cmprsk}
\alias{sas.cmprsk}
\title{generate prediction equation for a competing risks regression models}
\usage{
sas.cmprsk(f, time = NA, baseonly = FALSE, file = "", append = FALSE)
}
\arguments{
\item{f}{a model fit from the competing risks regression.}

\item{time}{time point}

\item{baseonly}{logical variable. If true, only base survival probability
will be printed.}

\item{file}{A connection, or a character string naming the file to print to}

\item{append}{logical. Only used if the argument file is the name of file.
If TRUE output will be appended to file; otherwise, it will overwrite the
content of file}
}
\value{
\item{out }{a character vector that can be output as a formula by
  function cat} \item{Rout }{same as out except replacing
  \code{"max"},\code{"min"},\code{"="} and \code{"**"} with
  \code{"pmax"},\code{"pmin"}, \code{"=="} and
  \eqn{\mbox{\textasciicircum}}{"^"} respectively so that the formula can
  be pasted to R session and compute \code{X} beta directly without any
  further modification}
}
\description{
Generate an equation to calculate X beta from a crr model fit
If specify a time point, the function also generates the subcumulative rate
at the time point.
}
\details{
f should be fitted by the function \code{\link[QHScrnomo]{crr.fit}}
}
\examples{

data(prostate.dat)
dd <- datadist(prostate.dat)
options(datadist = "dd")
prostate.f <- cph(Surv(TIME_EVENT,EVENT_DOD == 1) ~ TX  + rcs(PSA,3) +
           BX_GLSN_CAT +  CLIN_STG + rcs(AGE,3) +
           RACE_AA, data = prostate.dat,
           x = TRUE, y= TRUE, surv=TRUE,time.inc = 144)
prostate.crr <- crr.fit(prostate.f,cencode = 0,failcode = 1)
sas.cmprsk(prostate.crr, time = 60)

}
\seealso{
\code{\link[rms]{sascode}},\code{\link[rms]{Function}},
  \code{\link[QHScrnomo]{crr.fit}}
}
\author{
changhong
}
\keyword{regression}
\keyword{survival}
