% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ALoD.R
\name{mleALoD}
\alias{mleALoD}
\title{Maximum likelihood estimation (MLE) for the quantile-based asymmetric logistic distribution.}
\usage{
mleALoD(y)
}
\arguments{
\item{y}{This is a vector of quantiles.}
}
\value{
The maximum likelihood estimate of parameter \eqn{\theta=(\mu,\phi,\alpha)} of the quantile-based asymmetric family of distributions.
}
\description{
The log-likelihood function \eqn{\ell_n(\mu,\phi,\alpha)=\ln[L_n(\mu,\phi,\alpha)]}
and parameter estimation of \eqn{ \theta=(\mu,\phi,\alpha)} in the quantile-based asymmetric logistic distribution
by using the maximum likelihood estimation are discussed in Gijbels et al. (2019a).
}
\examples{
# Example
rnum=rnorm(100)
mleALoD(rnum)

}
\references{
{
 Gijbels, I., Karim, R. and Verhasselt, A. (2019a). On quantile-based asymmetric family of distributions: properties and inference. \emph{International Statistical Review}, \url{https://doi.org/10.1111/insr.12324}.
}
}
