% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/PyImport.R
\name{pyImport}
\alias{pyImport}
\title{Import virtual Python objects to R}
\usage{
pyImport(import, from = NULL, as = NULL, env = parent.frame())
}
\arguments{
\item{import}{a character giving the names of the objects to import.}

\item{from}{an optional character string giving the name of the module.}

\item{as}{an optional string defining an alias for the module name.}

\item{env}{an optional environment where the virtual Python objects are
assigned to.}
}
\description{
A convenience function to call the Python function
             \bold{import} and creating virtual Python objects for
             the imported objects in R.
}
\details{
The function pyImport works like the import function in Python.

         The function pyImport has a special behavior for the packages numpy
         and pandas. For these two packages pyImport does not only import
         numpy but also register their alias in pyOptions. To be found when
         pySet is used with the option useNumpy set to TRUE.
}
\examples{
\dontshow{PythonInR:::pyCranConnect()}
pyImport("os")
\dontrun{
#NOTE: The following does not only import numpy but also register the
#      alias in the options under the name "numpyAlias".
#      The same is done for pandas, the default alias for pandas and numpy
#      are respectively "pandas" and "numpy". The numpyAlias is used
#      when calling pySet with the pyOption useNumpy set to TRUE.
pyOptions("numpyAlias")
pyImport("numpy", as="np")
pyOptions("numpyAlias")
pyImport("pandas", as="pd")
pyImport(c("getcwd", "sep"), from="os")
getcwd()
sep
sep = "Hello R!"
pyExecp("sep")
}
}

