% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specialFrame.R
\name{specialFrame}
\alias{specialFrame}
\title{Special frame}
\usage{
specialFrame(formula, data, unspecials.design = TRUE, specials,
  specials.factor = TRUE, specials.design = FALSE, strip.specials = TRUE,
  strip.arguments = NULL, strip.alias = NULL, strip.unspecials = NULL,
  drop.intercept = TRUE, response = TRUE, na.action = options()$na.action)
}
\arguments{
\item{formula}{Formula whose left hand side specifies the event
history, i.e., either via Surv() or Hist().}

\item{data}{Data frame in which the formula is interpreted}

\item{unspecials.design}{Passed as is to
\code{\link{model.design}}.}

\item{specials}{Character vector of special function names.
Usually the body of the special functions is function(x)x but
e.g., \code{\link{strata}} from the survival package does treat
the values}

\item{specials.factor}{Passed as is to \code{\link{model.design}}.}

\item{specials.design}{Passed as is to \code{\link{model.design}}}

\item{strip.specials}{Passed as \code{specials} to
\code{\link{strip.terms}}}

\item{strip.arguments}{Passed as \code{arguments} to
\code{\link{strip.terms}}}

\item{strip.alias}{Passed as \code{alias.names} to
\code{\link{strip.terms}}}

\item{strip.unspecials}{Passed as \code{unspecials} to
\code{\link{strip.terms}}}

\item{drop.intercept}{Passed as is to \code{\link{model.design}}}

\item{response}{If FALSE do not get response data.}

\item{na.action}{Decide what to do with missing values.}
}
\value{
A list which contains
- the response
- the design matrix (see \code{\link{model.design}})
- one entry for each special (see \code{\link{model.design}})
}
\description{
Extract data and design matrix including specials from call
}
\details{
Obtain a list with the data used for event history regression analysis. This
function cannot be used directly on the user level but inside a function
to prepare data for survival analysis.
}
\examples{

## Here are some data with an event time and no competing risks
## and two covariates X1 and X2.
## Suppose we want to declare that variable X1 is treated differently
## than variable X2. For example, X1 could be a cluster variable, or
## X1 should have a proportional effect on the outcome.
d <- data.frame(y=1:7,
                X2=c(2.24,3.22,9.59,4.4,3.54,6.81,5.05),
                X3=c(1,1,1,1,0,0,1),
                X4=c(44.69,37.41,68.54,38.85,35.9,27.02,41.84),
                X1=factor(c("a","b","a","c","c","a","b"),
                    levels=c("c","a","b")))
## define special functions prop and cluster
prop <- function(x)x
cluster <- function(x)x
## We pass a formula and the data
e <- specialFrame(y~prop(X1)+X2+cluster(X3)+X4,
                  data=d,
                  specials=c("prop","cluster"))
## The first element is the response
e$response
## The other elements are the design, i.e., model.matrix for the non-special covariates
e$design
## and a data.frame for the special covariates
e$prop
## The special covariates can be returned as a model.matrix 
e2 <- specialFrame(y~prop(X1)+X2+cluster(X3)+X4,
                   data=d,
                   specials=c("prop","cluster"),
                   specials.design=TRUE)
e2$prop
## and the non-special covariates can be returned as a data.frame
e3 <- specialFrame(y~prop(X1)+X2+cluster(X3)+X4,
                   data=d,
                   specials=c("prop","cluster"),
                   specials.design=TRUE,
                   unspecials.design=FALSE)
e3$design
}
\seealso{
model.frame model.design Hist
}
\author{
Thomas A. Gerds <tag@biostat.ku.dk>
}
