% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{download_dgm}
\alias{download_dgm}
\alias{download_dgm_datasets}
\alias{download_dgm_results}
\alias{download_dgm_measures}
\title{Download Datasets/Results/Measures of a DGM}
\usage{
download_dgm_datasets(
  dgm_name,
  overwrite = FALSE,
  progress = TRUE,
  max_try = 10
)

download_dgm_results(
  dgm_name,
  overwrite = FALSE,
  progress = TRUE,
  max_try = 10
)

download_dgm_measures(
  dgm_name,
  overwrite = FALSE,
  progress = TRUE,
  max_try = 10
)
}
\arguments{
\item{dgm_name}{Character string specifying the name of the DGM dataset to download.}

\item{overwrite}{Logical indicating whether to overwrite existing files.
Defaults to \code{FALSE}, which means only missing files will be downloaded.}

\item{progress}{Logical indicating whether to show progress downloading files.
Defaults to \code{TRUE}.}

\item{max_try}{Integet specifying how many times should the function attempt reconnecting to OSF upon failure.}
}
\value{
\code{TRUE} if the download was successful, otherwise an error is raised.
}
\description{
This function downloads datasets/results/measures of a specified Data-Generating Mechanism (DGM)
from the OSF repository (\url{https://osf.io/exf3m/}). The datasets/results/measures are saved
to the location specified via \code{PublicationBiasBenchmark.get_option("resources_directory")}.
To set the location permanently, specify the \code{PublicationBiasBenchmark_RESOURCES} environmental
variable. The data are stored in dgm_name/datasets, dgm_name/results, dgm_name/measures subfolders.
}
\examples{
\donttest{
  download_dgm_datasets("no_bias")
}

}
