% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest_bygroup.R
\name{forest_bygroup}
\alias{forest_bygroup}
\title{Forest plot: colored by groups}
\usage{
forest_bygroup(
  data,
  summarystat,
  upperci,
  lowerci,
  population.name,
  group.name = population.name,
  color.group.name = population.name,
  stat.label = "Hazard Ratio",
  text.column = NULL,
  text.column.addition = NULL,
  color = NULL,
  stat.type.hr = TRUE,
  log.scale = FALSE,
  extra.stat = NULL,
  extra.stat.label = NULL,
  endpoint.name = "OS",
  study.name = "",
  draw = TRUE,
  shape.column = NULL,
  shape.vec = NULL
)
}
\arguments{
\item{data}{data frame. plotting order will be following the order in the data frame.}

\item{summarystat}{column name that indicates the summary statistics
column (e.g. HR, ORR)}

\item{upperci, lowerci}{column names that indicate the lower and upper CI
of the summary statistics}

\item{population.name}{column name of the column which indicates population names of the
summary statistics}

\item{group.name}{column name of the column which indicates which group each population is in.
group names will be shown in the left panel of the forest plot}

\item{color.group.name}{column name of the column which indicates how to color different groups}

\item{stat.label}{Y axis label text}

\item{text.column}{column name of the column which provides texts to be display on the right side
of the forest plot. If it is NULL, the text will be generated by pasting summary stat column,
the lowerci column and the upperci column}

\item{text.column.addition}{additional columns to put (will be placed on the right of the figures), could be
a vector of multiple column names}

\item{color}{customized colors to different groups.}

\item{stat.type.hr}{whether the summary statistics is HR. If so, the forest plot will be centered at 1}

\item{log.scale}{whether show summary statistics in log scale}

\item{extra.stat}{column name of the column which indicates the extra statistics to be drawn on
the forest plot. The extra statistics will be drawn by "+". Could be NULL}

\item{extra.stat.label}{label of the extra.stat (to be shown on y axis)}

\item{endpoint.name, study.name}{text to be shown in title}

\item{draw}{whether to draw}

\item{shape.column}{column to pass to adjust shape. Use NULL for none}

\item{shape.vec}{a vector to sepecify shapes, e.g. c(15, 16).}
}
\value{
return forest plot of class \code{grob}.
}
\description{
Forest plot: colored by groups
}
\examples{
 
library(dplyr)
clinical_1 <- clinical \%>\% mutate( 
  indicator = case_when(
    STRATUM == "strata_1" ~ 0, 
    STRATUM == "strata_2" ~ 1,
    is.na(STRATUM) & ARM == "experimental" ~ 1,
    TRUE ~ -1 
  ),
  ARM  = factor(ARM, levels = c("control","experimental")),
  BNLR = case_when(
    is.na(BNLR) ~ median(BNLR, na.rm = TRUE),
    TRUE ~ BNLR
  )
) 
ipw_res <- ipw_strata(
  data.in = clinical_1, formula = indicator ~ BECOG + SEX + BNLR,
  indicator.var = "indicator", tte = "OS_MONTH", event = "OS_EVENT", trt = "ARM",
  class.of.int = list("strata_1" = 1, "strata_2" = 0)
 )
boot_ipw <- bootstrap_propen(
  data.in = clinical_1, formula = indicator ~ BECOG + SEX + BNLR,
  indicator.var = "indicator", tte = "OS_MONTH", event = "OS_EVENT", trt = "ARM",
  class.of.int = list("strata_1" = 1, "strata_2" = 0),
  estimate.res = ipw_res, method = "ipw", n.boot = 5
)
ps_res <- ps_match_strata(
  data.in = clinical_1, formula = indicator ~ BECOG + SEX + BNLR,
  indicator.var = "indicator", tte = "OS_MONTH", event = "OS_EVENT", trt = "ARM",
  class.of.int = list("strata_1" = 1, "strata_2" = 0)
 )
boot_ps <- bootstrap_propen(
  data.in = clinical_1, formula = indicator ~ BECOG + SEX + BNLR, 
  indicator.var = "indicator", tte = "OS_MONTH", event = "OS_EVENT", trt = "ARM",
  class.of.int = list("strata_1" = 0, "strata_2" = 1),
  estimate.res = ps_res, method = "ps", n.boot = 5
)
boot.out.ipw <- boot_ipw$boot.out.est
boot.out.ps <- boot_ps$boot.out.est
ipw.ci.mat <- boot_ipw$est.ci.mat
ps.ci.mat <- boot_ps$est.ci.mat

data.fp <- data.frame(
  HR = round(exp(c(ipw.ci.mat[, 1], ps.ci.mat[, 1])), 2),
  LOWER = round(exp(c(ipw.ci.mat[, 2], ps.ci.mat[, 2])), 2),
  UPPER = round(exp(c(ipw.ci.mat[, 3], ps.ci.mat[, 3])), 2),
  ADA_Group = rep(rownames(ipw.ci.mat), 2),
  n = paste("n =", rep(table(clinical_1$indicator)[c("0", "1")], 2)),
  Methods_ADA = paste(
    rep(c("IPW", "PS"), each = 2), rep(rownames(ipw.ci.mat), 2)
  ),
  Methods = rep(c("IPW", "PS"), each = 2),
  bootstrapHR = c(
    boot.out.ipw[grep("HR", rownames(boot.out.ipw)), "Median"],
    boot.out.ps[grep("HR", rownames(boot.out.ps)), "Median"]
  )
)
forest_bygroup(
  data = data.fp, summarystat = "HR", upperci = "UPPER", lowerci = "LOWER",
  population.name = "Methods_ADA", group.name = "Methods",
  color.group.name = "ADA_Group", text.column.addition = "n",
  stat.label = "Hazard Ratio", text.column = NULL,
  stat.type.hr = TRUE, log.scale = FALSE, extra.stat = "bootstrapHR",
  extra.stat.label = "bootstrap median",
  endpoint.name = "OS", study.name = "Example Study", draw = TRUE
 ) 
}
