% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extr_outs.R
\name{extr_outs}
\alias{extr_outs}
\title{Extract outputs from \code{stanfit} objects obtained from \link{bayes_met}}
\usage{
extr_outs(model, probs = c(0.025, 0.975), verbose = FALSE)
}
\arguments{
\item{model}{An object of class \code{stanfit}, obtained using \code{\link[=bayes_met]{bayes_met()}}}

\item{probs}{A vector with two elements representing the probabilities
(in decimal scale) that will be considered for computing the quantiles.}

\item{verbose}{A logical value. If \code{TRUE}, the function will indicate the
completed steps. Defaults to \code{FALSE}}
}
\value{
The function returns an object of class \code{extr}, which is a list with:
\itemize{
\item \code{variances} : a data frame containing the variance components of
the model effects, their standard deviation, naive standard error and highest
posterior density interval.
\item \code{post} : a list with the posterior of the effects, and the data
generated by the model.
\item \code{map} : a list with the maximum posterior values of each effect
\item \code{ppcheck} : a matrix containing the p-values of maximum, minimum,
median, mean and standard deviation; effective number of parameters, WAIC2
value, Rhat and effective sample size.
}
}
\description{
Extracts outputs of the Bayesian model fitted
using \code{\link[=bayes_met]{bayes_met()}}, and provides some diagnostics.
}
\details{
More details about the usage of \code{extr_outs} and other functions of
the \code{ProbBreed} package can be found at \url{https://saulo-chaves.github.io/ProbBreed_site/}.
}
\examples{
\donttest{
mod = bayes_met(data = soy,
                gen = "Gen",
                loc = "Loc",
                repl = NULL,
                year = NULL,
                reg = NULL,
                res.het = TRUE,
                trait = 'Y',
                iter = 6000, cores = 4, chains = 4)

outs = extr_outs(model = mod,
                 probs = c(0.05, 0.95),
                 verbose = TRUE)
}
}
\seealso{
\link[rstan:stan_plot_diagnostics]{rstan::stan_diag}, \link[ggplot2:ggplot]{ggplot2::ggplot}, \link[rstan:check_hmc_diagnostics]{rstan::check_hmc_diagnostics}, \link{plot.extr}
}
