% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07PTBlock.r
\name{PTBlock}
\alias{PTBlock}
\alias{PTBlock,PTPattern,numeric,numeric-method}
\title{Select and copy a range of PTCells into a PTBlock}
\usage{
\S4method{PTBlock}{PTPattern,numeric,numeric}(pattern, row, track)
}
\arguments{
\item{pattern}{A \code{\link{PTPattern}} object from which the
\code{PTBlock} needs to be selected.}

\item{row}{A \code{numeric} index or indices of rows that needs to be
copied from the \code{pattern} into the PTBlock.}

\item{track}{A \code{numeric} index or indices of tracks that needs to be
copied from the \code{pattern} into the PTBlock.}
}
\value{
Returns a \code{matrix} from the selected \code{row}s and \code{track}s
from the \code{pattern}. Each element in the \code{matrix} is a \code{list} holding
a single \code{\link{PTCell}}.
}
\description{
Select and copy a range of \code{\link{PTCell}}s from a
\code{\link{PTPattern}} into a \code{PTBlock}. This
allows a more flexible approach to select and modify
\code{\link{PTCell}}s and paste the modified cells back into
a \code{\link{PTPattern}}.
}
\details{
Most objects in this \link{ProTrackR} package are very strict in the operations
that are allowed, in order to guarantee validity and compatibility with
the original ProTracker. This makes those objects not very flexible.

This \code{\link{PTBlock}} is not a formal S4 object, in fact you
can hardly call it an object at all. It is just a \code{matrix}, where each
element holds a \code{list} with a single \code{\link{PTCell}}.

This \code{matrix} is very flexible and makes it easier to select and modify
the cells. This flexibility comes at a cost as validity is only checked
at the level of the \code{\link{PTCell}}s. The \code{PTBlock}
can be pasted back into a \code{\link{PTPattern}} with the
\code{\link{pasteBlock}} method. At which point validity will be checked again. If your modifications
resulted in violation of ProTracker standards, you should not be able to
paste the block into a pattern.
}
\examples{
data("mod.intro")

## in most ProTrackR methods you can only select a single row or track.
## with a PTBlock your selection is more flexible.

## select rows 4 up to 8 and tracks 2 up to 4, from the first
## pattern table in mod.intro:

block <- PTBlock(PTPattern(mod.intro, 1), 4:8, 2:4)

## 'block' is now a matrix with in each a list with a PTCell.
## These can now easily be accessed and modified:

cell1 <- block[1, 1][[1]]

print(cell1)
}
\seealso{
Other block.operations: 
\code{\link{pasteBlock}()}
}
\author{
Pepijn de Vries
}
\concept{block.operations}
