% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01supporting_functions.r
\name{unsignedIntToRaw}
\alias{unsignedIntToRaw}
\title{Convert unsigned integer into a raw vector}
\usage{
unsignedIntToRaw(int_dat, length.out = 1)
}
\arguments{
\item{int_dat}{A single integer value. If a list or vector of values.
is provided, only the first element is evaluated. Input data are converted
to absolute integer values.}

\item{length.out}{Required length of the vector that will hold the resulting.
\code{raw} data. Defaults to 1. If the value of \code{int_dat} is to large to convert into
\code{raw} data of length \code{length.out}, data will be clipped.}
}
\value{
A vector of length \code{length.out}, holding \code{raw} data.
}
\description{
This function converts an unsigned integer into a vector of \code{raw} data.
}
\details{
This function converts an unsigned integer value into a vector (with
a specified length, namely \code{length.out}) of \code{raw} data. For the
inverse of this function use \code{\link{rawToUnsignedInt}(raw_dat)}
}
\examples{
## generate some unsigned integer:
some.integer <- 43251

## convert the unsigned integer into raw data:
unsignedIntToRaw(some.integer, length.out = 4)

\dontrun{
## note that the integer is too large to store as raw with length.out = 1:
unsignedIntToRaw(some.raw.data, length.out = 1)
}

}
\author{
Pepijn de Vries
}
\seealso{
Other integer.operations: \code{\link{nybbleToSignedInt}},
  \code{\link{nybble}}, \code{\link{rawToSignedInt}},
  \code{\link{rawToUnsignedInt}},
  \code{\link{signedIntToNybble}},
  \code{\link{signedIntToRaw}}, \code{\link{waveform}}

Other raw.operations: \code{\link{as.raw}},
  \code{\link{nybbleToSignedInt}}, \code{\link{nybble}},
  \code{\link{rawToCharNull}},
  \code{\link{rawToSignedInt}},
  \code{\link{rawToUnsignedInt}},
  \code{\link{signedIntToNybble}},
  \code{\link{signedIntToRaw}}
}

