% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/go.profiles.R
\name{go.profiles}
\alias{go.profiles}
\title{GO enrichment comparison}
\usage{
go.profiles(g_ref, g_comp, color = c("red", "white"), onto = c("MF", "BP",
  "CC"), mode = c("number", "frequency"), demonstration.number = 10,
  plot = TRUE, ...)
}
\arguments{
\item{g_ref}{Vector of the first set of molecules.}

\item{g_comp}{Vector of the second set of molecules.}

\item{color}{Color represent of the two sets.}

\item{onto}{GO categories, three possible values are \code{MF} for GO function, \code{BP} for GO process, and \code{CC} for GO componet}

\item{mode}{Mode of the GO vlues, either \code{Frequency} or \code{Number}.}

\item{demonstration.number}{Number of the top GOs to display.}

\item{plot}{Logical value, whether to plot the profiling result (if \code{TRUE}) or not (if \code{FALSE}).}

\item{...}{other arguments.}
}
\value{
A data frame of the profiling result and plots.
}
\description{
GO enrichment comparison between networks.
}
\examples{
entrez1<-c("11067","414157","196477","147339","642")
entrez2<-c("121549","51160","83878","11338","196477","9319","608","7015")
go.profiles(entrez1,onto="MF",main="Only Network 1")
go.profiles(entrez1,entrez2,onto="MF",main=c("Network 1 vs 2"))
}

