% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelCluster.R
\name{ModelCluster}
\alias{ModelCluster}
\title{Model based Clustering}
\usage{
ModelCluster(Data, NewData = NULL, G, ...)
}
\arguments{
\item{Data}{(dataframe) Data dataframe}

\item{NewData}{(optional) (dataframe) New Data frame for which the class membership is requested}

\item{G}{(optional) (numeric) No. of components to verify}

\item{...}{(optional) additional arguments for the function}
}
\value{
\code{class membership} of the clustered \code{NewData}
}
\description{
A simple function to perform Model based cluster Analysis
:
}
\details{
The function implements Model based clustering in predictive framework. Model based clustering approaches provide a
structured way of choosing number of clusters (C. Fraley & Raftery, 1998). 
Data are considered to be generated from a set of Gaussian distributions (components or clusters) 
i.e. as a mixture of these components (mixture models). Instead of using heuristics, model based 
clustering approximates Bayes factor (utilizing Bayesian information Criterion) to determine the model 
with the highest evidence (as provided by the data).
}
\examples{
# clustering kinematics data at 10\% of movement
# not run
# cluster_time <- ModelCluster(KinData[,c(2,12,22,32,42,52,62,72,82,92,102,112)],G=1:12)

}
\author{
Atesh Koul, C'MON unit, Istituto Italiano di Tecnologia

\email{atesh.koul@iit.it}
}

