% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{invert_signal}
\alias{invert_signal}
\title{Invert Signal Values for Preference Reversal}
\usage{
invert_signal(signal_df)
}
\arguments{
\item{signal_df}{Data frame with Date column and signal columns}
}
\value{
Data frame with inverted signal values
}
\description{
Transforms signal values using (1 - value) to reverse preference direction.
Useful when high values indicate something to avoid. For example, inverting
volatility makes low-vol stocks appear as high signals.
}
\examples{
data("sample_prices_weekly")
# Prefer low volatility stocks
volatility <- calc_rolling_volatility(sample_prices_weekly, 20)
stability_signal <- invert_signal(volatility)
# Select top 10 momentum stocks first
momentum <- calc_momentum(sample_prices_weekly, 12)
selected <- filter_top_n(momentum, 10)
# Weight by inverted volatility (low vol = high weight)
weights <- weight_by_signal(selected, stability_signal)
}
