/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.session;

import org.openfast.error.ErrorHandler;
import org.openfast.session.Connection;
import org.openfast.session.ConnectionListener;
import org.openfast.session.Endpoint;
import org.openfast.session.FastConnectionException;
import org.openfast.session.Session;
import org.openfast.session.SessionHandler;
import org.openfast.session.SessionProtocol;

public class FastServer
implements ConnectionListener {
    private ErrorHandler errorHandler = ErrorHandler.DEFAULT;
    private SessionHandler sessionHandler = SessionHandler.NULL;
    private final SessionProtocol sessionProtocol;
    private final Endpoint endpoint;
    private final String serverName;
    private Thread serverThread;

    public FastServer(String serverName, SessionProtocol sessionProtocol, Endpoint endpoint) {
        if (endpoint == null || sessionProtocol == null) {
            throw new NullPointerException();
        }
        this.endpoint = endpoint;
        this.sessionProtocol = sessionProtocol;
        this.serverName = serverName;
        endpoint.setConnectionListener(this);
    }

    public void listen() {
        if (this.serverThread == null) {
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        FastServer.this.endpoint.accept();
                    }
                    catch (Exception e) {
                        FastServer.this.errorHandler.error(null, null, e);
                        FastServer.this.endpoint.close();
                    }
                }
            };
            this.serverThread = new Thread(runnable, "FastServer");
        }
        this.serverThread.start();
    }

    public void close() throws FastConnectionException {
        this.endpoint.close();
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler == null) {
            throw new NullPointerException();
        }
        this.errorHandler = errorHandler;
    }

    public void onConnect(Connection connection) {
        Session session = this.sessionProtocol.onNewConnection(this.serverName, connection);
        this.sessionHandler.newSession(session);
    }

    public void setSessionHandler(SessionHandler sessionHandler) {
        this.sessionHandler = sessionHandler;
    }
}

