/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.template;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.openfast.BitVectorBuilder;
import org.openfast.BitVectorReader;
import org.openfast.Context;
import org.openfast.FieldValue;
import org.openfast.Global;
import org.openfast.GroupValue;
import org.openfast.IntegerValue;
import org.openfast.QName;
import org.openfast.ScalarValue;
import org.openfast.SequenceValue;
import org.openfast.error.FastConstants;
import org.openfast.template.Field;
import org.openfast.template.FieldSet;
import org.openfast.template.Group;
import org.openfast.template.Scalar;
import org.openfast.template.operator.Operator;
import org.openfast.template.type.Type;

public class Sequence
extends Field
implements FieldSet {
    private static final long serialVersionUID = 1L;
    private final Group group;
    private final Scalar length;
    private boolean implicitLength;

    public Sequence(QName name, Field[] fields, boolean optional) {
        this(name, Sequence.createLength(name, optional), fields, optional);
        this.implicitLength = true;
    }

    public Sequence(String name, Field[] fields, boolean optional) {
        this(new QName(name), fields, optional);
    }

    public Sequence(QName name, Scalar length, Field[] fields, boolean optional) {
        super(name, optional);
        this.group = new Group(name, fields, optional);
        if (length == null) {
            this.length = Sequence.createLength(name, optional);
            this.implicitLength = true;
        } else {
            this.length = length;
        }
    }

    private static Scalar createLength(QName name, boolean optional) {
        return new Scalar(Global.createImplicitName(name), Type.U32, Operator.NONE, ScalarValue.UNDEFINED, optional);
    }

    public int getFieldCount() {
        return this.group.getFieldCount();
    }

    public Field getField(int index) {
        return this.group.getField(index);
    }

    public Scalar getLength() {
        return this.length;
    }

    public boolean usesPresenceMapBit() {
        return this.length.usesPresenceMapBit();
    }

    public boolean isPresenceMapBitSet(byte[] encoding, FieldValue fieldValue) {
        return this.length.isPresenceMapBitSet(encoding, fieldValue);
    }

    public byte[] encode(FieldValue value, Group template, Context context, BitVectorBuilder presenceMapBuilder) {
        if (this.hasTypeReference()) {
            context.setCurrentApplicationType(this.getTypeReference());
        }
        if (value == null) {
            return this.length.encode(null, template, context, presenceMapBuilder);
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        SequenceValue val = (SequenceValue)value;
        int len = val.getLength();
        try {
            buffer.write(this.length.encode(new IntegerValue(len), template, context, presenceMapBuilder));
            Iterator iter = val.iterator();
            while (iter.hasNext()) {
                buffer.write(this.group.encode((FieldValue)iter.next(), template, context));
            }
        }
        catch (IOException e) {
            Global.handleError(FastConstants.IO_ERROR, "An IO error occurred while encoding " + this, e);
        }
        return buffer.toByteArray();
    }

    public FieldValue decode(InputStream in, Group template, Context context, BitVectorReader pmapReader) {
        SequenceValue sequenceValue = new SequenceValue(this);
        ScalarValue lengthValue = (ScalarValue)this.length.decode(in, template, context, pmapReader);
        if (lengthValue == ScalarValue.NULL || lengthValue == null) {
            return null;
        }
        int len = lengthValue.toInt();
        int i = 0;
        while (i < len) {
            sequenceValue.add((GroupValue)this.group.decode(in, template, context, BitVectorReader.INFINITE_TRUE));
            ++i;
        }
        return sequenceValue;
    }

    public Class getValueType() {
        return SequenceValue.class;
    }

    public FieldValue createValue(String value) {
        return new SequenceValue(this);
    }

    public String getTypeName() {
        return "sequence";
    }

    public Group getGroup() {
        return this.group;
    }

    public boolean hasField(String fieldName) {
        return this.group.hasField(fieldName);
    }

    public boolean isImplicitLength() {
        return this.implicitLength;
    }

    public void setTypeReference(QName typeReference) {
        this.group.setTypeReference(typeReference);
    }

    public QName getTypeReference() {
        return this.group.getTypeReference();
    }

    public boolean hasTypeReference() {
        return this.group.hasTypeReference();
    }

    public String toString() {
        return this.name.getName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
        result = 31 * result + (this.length == null ? 0 : this.length.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Sequence other = (Sequence)obj;
        if (!this.group.equals(other.group)) {
            return false;
        }
        if (this.isImplicitLength() != other.isImplicitLength()) {
            return false;
        }
        return this.isImplicitLength() || this.length.equals((Object)other.length);
    }

    public boolean hasAttribute(QName attributeName) {
        return this.group.hasAttribute(attributeName);
    }

    public String getAttribute(QName name) {
        return this.group.getAttribute(name);
    }
}

