/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.examples;

import java.io.IOException;
import java.io.OutputStream;
import org.openfast.Message;
import org.openfast.MessageBlockWriter;
import org.openfast.examples.OpenFastExample;
import org.openfast.impl.CmeMessageBlockWriter;
import org.openfast.impl.CmeTcpReplayMessageBlockWriter;

public class MessageBlockWriterFactory {
    final OpenFastExample.Variant variant;
    final int offset;
    final boolean isMulticast;

    public MessageBlockWriterFactory() {
        this(OpenFastExample.Variant.DEFAULT, 0, true);
    }

    public MessageBlockWriterFactory(OpenFastExample.Variant variant, int offset, boolean isMulticast) {
        this.variant = variant;
        this.offset = offset;
        this.isMulticast = isMulticast;
    }

    public MessageBlockWriter create() {
        if (OpenFastExample.Variant.CME == this.variant) {
            if (this.isMulticast) {
                return new CmeMessageBlockWriter();
            }
            return new CmeTcpReplayMessageBlockWriter();
        }
        return this.createDefault();
    }

    MessageBlockWriter createDefault() {
        if (this.offset <= 0) {
            return MessageBlockWriter.NULL;
        }
        return new MessageBlockWriter(){
            final byte[] PREAMBLE;
            {
                this.PREAMBLE = new byte[MessageBlockWriterFactory.this.offset];
            }

            public void writeBlockLength(OutputStream out, Message message, byte[] data) throws IOException {
                try {
                    out.write(this.PREAMBLE);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
    }
}

