/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.portfolioeffect.quant.client.message.CalculationStatusMessage;
import com.portfolioeffect.quant.client.message.ClientMessage;
import com.portfolioeffect.quant.client.message.LogoutResponse;
import com.portfolioeffect.quant.client.message.NonparametricComputeResponse;
import com.portfolioeffect.quant.client.message.Reject;
import com.portfolioeffect.quant.client.message.ServiceMessage;
import com.portfolioeffect.quant.client.message.TestRequest;
import com.portfolioeffect.quant.client.message.TransmitDataListMessage;
import com.portfolioeffect.quant.client.message.TransmitDataRequest;
import com.portfolioeffect.quant.client.message.TransmitDataResponse;
import com.portfolioeffect.quant.client.message.ValidationResponse;
import com.portfolioeffect.quant.client.message.type.EncryptMethodType;
import com.portfolioeffect.quant.client.message.type.EncryptedPasswordMethodType;
import com.portfolioeffect.quant.client.message.type.FastMessageType;
import com.portfolioeffect.quant.client.message.util.ClientRequestMessageFactory;
import com.portfolioeffect.quant.client.message.util.CryptograhicUtils;
import com.portfolioeffect.quant.client.message.util.ServerResponseMessageFactory;
import com.portfolioeffect.quant.client.message.util.ServerResponseMessageParser;
import com.portfolioeffect.quant.client.model.ConnectFailedException;
import com.portfolioeffect.quant.client.model.PriceDataSet;
import com.portfolioeffect.quant.client.portfolio.ArrayCache;
import com.portfolioeffect.quant.client.portfolio.ArrayCacheType;
import com.portfolioeffect.quant.client.result.MethodResult;
import com.portfolioeffect.quant.client.util.Console;
import com.portfolioeffect.quant.client.util.ProgressBar;
import com.portfolioeffect.quant.client.util.StopWatch;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.SerializationUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.iq80.snappy.Snappy;
import org.openfast.Context;
import org.openfast.Message;
import org.openfast.MessageInputStream;
import org.openfast.MessageOutputStream;
import org.openfast.error.FastException;
import org.openfast.examples.MessageBlockReaderFactory;
import org.openfast.examples.MessageBlockWriterFactory;
import org.openfast.examples.OpenFastExample;
import org.openfast.session.Connection;
import org.openfast.session.Endpoint;
import org.openfast.session.FastConnectionException;
import org.openfast.session.tcp.TcpEndpoint;
import org.openfast.template.TemplateRegistry;
import org.openfast.template.loader.XMLMessageTemplateLoader;

public class ClientConnection {
    private static final int RESTART_ATTEMPTS_COUNT = 5;
    private static final int TIME_WAIT_TOPRINT = 30;
    private static final String SUPPORTED_CHARSET = "US-ASCII";
    private static final int TEST_PORT_NUMBER = 3443;
    private static final int MAX_BLOCK_DIMENSION = 100000;
    private static final int BLOCK_DIMENSION_DECREASE_STEP = 10;
    private static final int USER_LAYER_TIMEOUT_SECONDS_ESTIMATE = 300;
    private static final int DATA_TRANSMIT_TIMEOUT_SECONDS_ESTIMATE = 300;
    private static final int LOGON_TIMEOUT_SECONDS = 30;
    private static final int SERVICE_TIMEOUT_SEC = 30;
    private static final int PORT_NUMBER = 443;
    private static final String TEMPLATES_FILE = "config/template-quant.xml";
    private static final int LOGON_ATTEMPT_COUNT = 9;
    private static final int DEFAULT_LOGON_TIMEOUT_SEC = 30;
    private static final int HEARTBEAT_INTERVAL = 30;
    private static final EncryptMethodType ENCRYPT_METHOD_TYPE = EncryptMethodType.NONE;
    private String apiKey;
    private String username;
    private String password;
    private String templatesFileName;
    private String host;
    private int port;
    private Connection connection;
    private MessageOutputStream out;
    private MessageInputStream in;
    private MessageBlockWriterFactory messageBlockWriterFactory;
    private MessageBlockReaderFactory messageBlockReaderFactory;
    private volatile boolean isLoggedOn = false;
    private boolean isConnected = false;
    private boolean isMessageLoggingEnabled = true;
    private Logger logger = Logger.getLogger(this.getClass());
    private Thread inboundMessageRouter;
    private Endpoint endpoint;
    private TemplateRegistry templateRegistry;
    private int outboundMsgSeqNum;
    private int indicatorDefRequestNum;
    private volatile LinkedBlockingDeque<ClientMessage> clientMessageQueue;
    private volatile LinkedBlockingDeque<ServiceMessage> serviceMessageQueue;
    private StopWatch timeDataFast = new StopWatch();
    private StopWatch timeDataTransmit = new StopWatch();
    private boolean debugModeEnabled = false;
    private StringBuffer callStatus = new StringBuffer();
    private int groupSize = 1;
    private int progressBarI = 0;
    private int progressBarMax = 0;
    private Thread heartbeatMonitor;
    private ProgressBar progressBar = new ProgressBar();
    private long idClient;
    private static AtomicLong idClientGenerator;
    private static AtomicLong id;

    static {
        id = new AtomicLong();
        idClientGenerator = new AtomicLong();
    }

    public static long getNewId() {
        return id.incrementAndGet();
    }

    public long getIdClient() {
        return this.idClient;
    }

    public ClientConnection() {
        this.setMessageLoggingEnabled(false);
        this.setTemplatesFileName(TEMPLATES_FILE);
        this.setPort(443);
        this.idClient = idClientGenerator.getAndIncrement();
    }

    public long getIdC() {
        return this.idClient;
    }

    public void start() throws IOException, FastConnectionException {
        this.logger.setLevel(Level.ERROR);
        this.endpoint = new TcpEndpoint(this.host, this.port);
        XMLMessageTemplateLoader loader = new XMLMessageTemplateLoader();
        loader.setLoadTemplateIdFromAuxId(true);
        loader.load(Thread.currentThread().getContextClassLoader().getResourceAsStream(this.templatesFileName));
        this.templateRegistry = loader.getTemplateRegistry();
        Context context = new Context();
        context.setTemplateRegistry(this.templateRegistry);
        this.messageBlockWriterFactory = new MessageBlockWriterFactory(OpenFastExample.Variant.DEFAULT, 0, false);
        this.messageBlockReaderFactory = new MessageBlockReaderFactory(OpenFastExample.Variant.DEFAULT, 0, false);
        this.connection = this.endpoint.connect();
        this.in = new MessageInputStream(this.connection.getInputStream(), context);
        this.in.setBlockReader(this.messageBlockReaderFactory.create());
        this.out = new MessageOutputStream(this.connection.getOutputStream(), context);
        this.out.setBlockWriter(this.messageBlockWriterFactory.create());
        this.isConnected = true;
        this.logger.info((Object)("Client connected to endpoint " + this.endpoint));
        this.clientMessageQueue = new LinkedBlockingDeque();
        this.serviceMessageQueue = new LinkedBlockingDeque();
        this.inboundMessageRouter = new Thread(new InboundMessageWorker());
        this.inboundMessageRouter.start();
        this.heartbeatMonitor = new Thread(new HeartbeatMonitor());
        this.heartbeatMonitor.start();
    }

    public void stop() {
        if (this.isConnected) {
            try {
                if (this.isLoggedOn()) {
                    this.logout(30);
                }
                this.endpoint.close();
                this.connection.close();
                this.inboundMessageRouter.join();
                this.serviceMessageQueue.offer(new ServiceMessage(System.currentTimeMillis(), true));
                this.heartbeatMonitor.interrupt();
            }
            catch (Exception e) {
                throw new RuntimeException("Error while stoping client.", e);
            }
            this.isConnected = false;
        }
    }

    public void logout() {
        if (this.isConnected && this.isLoggedOn()) {
            Message logoutMsg = ClientRequestMessageFactory.createLogoutRequest(this.templateRegistry, this.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
            this.out.writeMessage(logoutMsg);
        }
    }

    public void logon() {
        try {
            this.logon(30);
        }
        catch (Exception e) {
            this.stop();
        }
    }

    public void logon(int timeoutSec) throws Exception {
        this.logon(timeoutSec, 0);
    }

    public boolean logon(int timeoutSec, int attemptCount) throws Exception {
        if (attemptCount > 9) {
            return false;
        }
        String encryptedPassword = CryptograhicUtils.encrypt(this.password, this.apiKey);
        Message loginMsg = ClientRequestMessageFactory.createLogonRequest(this.templateRegistry, 30, ENCRYPT_METHOD_TYPE, this.username, encryptedPassword, EncryptedPasswordMethodType.AES, encryptedPassword.length(), this.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
        Message msg = this.sendAndAwaitResponse(loginMsg, timeoutSec);
        FastMessageType responseMessageType = this.getMessageType(msg);
        String curentHost = this.getHost();
        int curentPort = this.getPort();
        if (responseMessageType == FastMessageType.LOGOUT) {
            LogoutResponse logoutReponse = ServerResponseMessageParser.parseLogoutResponse(msg);
            throw new Exception(logoutReponse.getText());
        }
        this.setHost(curentHost);
        this.setPort(curentPort);
        if (attemptCount == 0 && !this.isLoggedOn()) {
            throw new ConnectFailedException();
        }
        return this.isLoggedOn;
    }

    public void logout(int timeoutSec) {
        if (!this.isLoggedOn()) {
            return;
        }
        Message logoutMsg = ClientRequestMessageFactory.createLogoutRequest(this.templateRegistry, this.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
        try {
            this.sendAndAwaitResponse(logoutMsg, timeoutSec);
        }
        catch (Exception e) {
            this.isLoggedOn = false;
        }
    }

    public void progressBarIAdd(int value) {
        if (this.progressBarMax == 0) {
            this.progressBarMax = value * this.groupSize;
            this.progressBarI = 0;
        }
        this.progressBar.printCompletionStatus(this.progressBarI, this.progressBarMax);
        this.progressBarI += value;
        this.progressBar.printCompletionStatus(this.progressBarI, this.progressBarMax);
        if (this.progressBarI == this.progressBarMax) {
            this.createCallGroup(1);
        }
    }

    public void createCallGroup(int groupSize) {
        this.groupSize = groupSize;
        this.progressBarI = 0;
        this.progressBarMax = 0;
        this.progressBar.reset();
        this.progressBar.setScale(groupSize);
    }

    public void printProgressBar(double percent) {
        this.progressBar.printCompletionStatus(percent);
    }

    public void proggressBarOn() {
        this.progressBar.setON(true);
    }

    public void proggressBarOff() {
        this.progressBar.setON(false);
    }

    public void resetProgressBar() {
        this.progressBar.reset();
    }

    public void setHost(String host) {
        this.host = host;
        if (host.equals("localhost")) {
            this.setPort(3443);
        } else {
            this.setPort(443);
        }
    }

    public MethodResult start(String username, String password, String apiKey, String remoteHostName) {
        this.clearStatus();
        this.stop();
        this.setMessageLoggingEnabled(false);
        this.setTemplatesFileName(TEMPLATES_FILE);
        if (remoteHostName.equals("localhost")) {
            this.setPort(3443);
        } else {
            this.setPort(443);
        }
        this.setUsername(username);
        this.setPassword(password);
        this.setApiKey(apiKey);
        this.setHost(remoteHostName);
        try {
            this.start();
        }
        catch (Exception e) {
            this.stop();
            return new MethodResult("Cannot connect to server. Check remote host address and your firewall rules.");
        }
        try {
            this.logon(30);
        }
        catch (Exception e) {
            this.stop();
            if (e.getMessage().contains(":")) {
                return new MethodResult(e.getMessage().split(":")[1]);
            }
            return new MethodResult(e.getMessage());
        }
        return new MethodResult();
    }

    private void clearStatus() {
        this.callStatus.setLength(0);
    }

    public MethodResult restart() {
        int totalTime = 0;
        int i = 1;
        while (i <= 5) {
            block13: {
                this.stop();
                try {
                    if (i > 1) {
                        int waitTime = (int)((double)i * (5.0 + Math.random() * 2.0));
                        if ((totalTime += waitTime) > 30) {
                            Console.write("\nConnecting to  server.");
                        }
                        this.waitAndDots(waitTime, totalTime);
                    }
                }
                catch (InterruptedException waitTime) {
                    // empty catch block
                }
                this.clearStatus();
                try {
                    this.start();
                    this.logon(30);
                }
                catch (IOException e) {
                    break block13;
                }
                catch (FastConnectionException e) {
                    break block13;
                }
                catch (ConnectFailedException e) {
                    break block13;
                }
                catch (Exception e) {
                    this.stop();
                    return new MethodResult(e.getMessage());
                }
                if (this.isLoggedOn()) {
                    if (totalTime > 30) {
                        Console.writeln(".OK.");
                    }
                    return new MethodResult();
                }
            }
            ++i;
        }
        if (!this.isLoggedOn()) {
            return new MethodResult("Cannot connect to server. Check remote host address and your firewall rules.");
        }
        return new MethodResult();
    }

    private void waitAndDots(int sec, int totalTime) throws InterruptedException {
        if (totalTime > 30) {
            Console.write(".");
        }
        Thread.sleep(sec);
    }

    public double getDataVolume(double[] price, int[] timeSec) {
        PriceDataSet data;
        try {
            data = new PriceDataSet(price, timeSec);
        }
        catch (Exception e) {
            return 0.0;
        }
        double a = data.toBinaryZipCompress().length;
        return a / 1024.0 / 1024.0;
    }

    public double getDataVolume(double[] price) {
        return this.getDataVolume(price, new int[0]);
    }

    public static boolean isPureAscii(String v) {
        CharsetEncoder asciiEncoder = Charset.forName(SUPPORTED_CHARSET).newEncoder();
        return asciiEncoder.canEncode(v);
    }

    public MethodResult validateStringRequest(String requestString) throws Exception {
        if (!ClientConnection.isPureAscii(requestString)) {
            return new MethodResult("String contains a non-ASCII character.");
        }
        String[] paramList = new String[]{};
        Message msg = ClientRequestMessageFactory.createValidationRequest(this.getTemplateRegistry(), requestString, this.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
        Message responseMsg = this.sendAndAwaitResponse(msg, 300);
        ValidationResponse response = ServerResponseMessageParser.parseValidationResponse(responseMsg);
        if (!response.getMsgType().equals("OK")) {
            return new MethodResult(response.getMsgBody());
        }
        Type mapType = new TypeToken<String[]>(){}.getType();
        Gson gson = new Gson();
        paramList = (String[])gson.fromJson(response.getMsgBody(), mapType);
        MethodResult result = new MethodResult();
        result.setStringArray("positions", paramList);
        return result;
    }

    public MethodResult callEstimator(String estimatorType, double[] price, int timeStep) throws Exception {
        int[] timeSec = new int[price.length];
        int i = 0;
        while (i < price.length) {
            timeSec[i] = i * timeStep + 1;
            ++i;
        }
        return this.callEstimator(estimatorType, price, timeSec);
    }

    public MethodResult transmitHistoryPrice(String assetName) throws Exception {
        String requestType = "HISTORY_PRICE";
        String request = assetName;
        Message msg = ServerResponseMessageFactory.createTransmitDataRequest(this.getTemplateRegistry(), requestType, request, this.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
        Message responseMsg = this.sendAndAwaitResponse(msg, 300);
        TransmitDataResponse response = ServerResponseMessageParser.parseTransmitDataResponse(responseMsg);
        if (response.getMsgType().equals("OK")) {
            MethodResult result = new MethodResult();
            result.setMessage(response.getMsgBody());
            return result;
        }
        throw new Exception(response.getMsgBody());
    }

    public MethodResult transmitQuantity(String assetName, int[] dataInt, long[] time) throws Exception {
        boolean isFirstBlock = true;
        int position = 0;
        int i = 0;
        while (i < time.length / 100000) {
            int[] dataTransmit = new int[100000];
            long[] timeTransmit = new long[100000];
            System.arraycopy(time, position, timeTransmit, 0, 100000);
            System.arraycopy(dataInt, position, dataTransmit, 0, 100000);
            String type = "QUANTITY";
            if (!isFirstBlock) {
                type = String.valueOf(type) + ":+";
            } else {
                isFirstBlock = false;
            }
            String request = assetName;
            Message msg = ServerResponseMessageFactory.createTransmitDataRequest(this.getTemplateRegistry(), type, request, dataTransmit, timeTransmit, this.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
            Message responseMsg = this.sendAndAwaitResponse(msg, 300);
            TransmitDataResponse response = ServerResponseMessageParser.parseTransmitDataResponse(responseMsg);
            position += 100000;
            if (!response.getMsgType().equals("OK")) {
                throw new Exception(response.getMsgBody());
            }
            ++i;
        }
        if (time.length % 100000 != 0) {
            int[] dataTransmit = new int[time.length % 100000];
            long[] timeTransmit = new long[time.length % 100000];
            System.arraycopy(time, position, timeTransmit, 0, time.length % 100000);
            System.arraycopy(dataInt, position, dataTransmit, 0, time.length % 100000);
            String type = "QUANTITY";
            if (!isFirstBlock) {
                type = String.valueOf(type) + ":+";
            } else {
                isFirstBlock = false;
            }
            String request = assetName;
            Message msg = ServerResponseMessageFactory.createTransmitDataRequest(this.getTemplateRegistry(), type, request, dataTransmit, timeTransmit, this.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
            Message responseMsg = this.sendAndAwaitResponse(msg, 300);
            TransmitDataResponse response = ServerResponseMessageParser.parseTransmitDataResponse(responseMsg);
            if (!response.getMsgType().equals("OK")) {
                throw new Exception(response.getMsgBody());
            }
        }
        MethodResult result = new MethodResult();
        result.setMessage("NON");
        return result;
    }

    public MethodResult transmitUserPrice(String assetName, float[] dataFloat, long[] time) throws Exception {
        boolean isFirstBlock = true;
        int position = 0;
        int i = 0;
        while (i < time.length / 100000) {
            float[] dataTransmit = new float[100000];
            long[] timeTransmit = new long[100000];
            System.arraycopy(time, position, timeTransmit, 0, 100000);
            System.arraycopy(dataFloat, position, dataTransmit, 0, 100000);
            String type = "USER_PRICE";
            if (!isFirstBlock) {
                type = String.valueOf(type) + ":+";
            } else {
                isFirstBlock = false;
            }
            String request = assetName;
            Message msg = ServerResponseMessageFactory.createTransmitDataRequest(this.getTemplateRegistry(), type, request, dataTransmit, timeTransmit, this.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
            Message responseMsg = this.sendAndAwaitResponse(msg, 300);
            TransmitDataResponse response = ServerResponseMessageParser.parseTransmitDataResponse(responseMsg);
            position += 100000;
            if (!response.getMsgType().equals("OK")) {
                throw new Exception(response.getMsgBody());
            }
            ++i;
        }
        if (time.length % 100000 != 0) {
            float[] dataTransmit = new float[time.length % 100000];
            long[] timeTransmit = new long[time.length % 100000];
            System.arraycopy(time, position, timeTransmit, 0, time.length % 100000);
            System.arraycopy(dataFloat, position, dataTransmit, 0, time.length % 100000);
            String type = "USER_PRICE";
            if (!isFirstBlock) {
                type = String.valueOf(type) + ":+";
            } else {
                isFirstBlock = false;
            }
            String request = assetName;
            Message msg = ServerResponseMessageFactory.createTransmitDataRequest(this.getTemplateRegistry(), type, request, dataTransmit, timeTransmit, this.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
            Message responseMsg = this.sendAndAwaitResponse(msg, 300);
            TransmitDataResponse response = ServerResponseMessageParser.parseTransmitDataResponse(responseMsg);
            if (!response.getMsgType().equals("OK")) {
                throw new Exception(response.getMsgBody());
            }
        }
        MethodResult result = new MethodResult();
        result.setMessage("NON");
        return result;
    }

    public MethodResult transmitDataList(String fromTime, String toTime, ArrayList<String> dataList, String windowLength, String priceSamplingInterval, String momentsModel) throws Exception {
        this.timeDataFast.reset();
        this.timeDataTransmit.reset();
        String requestType = "CHECK_DATA";
        TransmitDataListMessage dataListMessage = new TransmitDataListMessage(dataList, windowLength, fromTime, toTime, priceSamplingInterval, momentsModel);
        Gson gson = new Gson();
        Type mapType = new TypeToken<TransmitDataListMessage>(){}.getType();
        String request = gson.toJson((Object)dataListMessage, mapType);
        this.timeDataFast.start();
        Message msg = ServerResponseMessageFactory.createTransmitDataRequest(this.getTemplateRegistry(), requestType, request, this.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
        this.timeDataFast.stop();
        this.timeDataTransmit.start();
        Message responseMsg = this.sendAndAwaitResponse(msg, 300);
        this.timeDataTransmit.stop();
        this.timeDataFast.start();
        TransmitDataResponse response = ServerResponseMessageParser.parseTransmitDataResponse(responseMsg);
        this.timeDataFast.stop();
        if (response.getMsgType().equals("OK")) {
            MethodResult result = new MethodResult();
            result.setMessage(response.getMsgBody());
            return result;
        }
        return new MethodResult(response.getMsgBody());
    }

    public MethodResult callEstimator(String estimatorType, double[] price, int[] timeSec) {
        ArrayCache resultTime;
        ArrayCache resultCache;
        double[] resultBlock;
        int pointer;
        double[] result = null;
        estimatorType = "[" + estimatorType + "]";
        if (this.progressBarMax == 0) {
            this.progressBarMax = price.length * this.groupSize;
            this.progressBarI = 0;
            this.progressBar.reset();
        }
        if (this.progressBarMax != 0 && this.progressBarI == 0) {
            this.progressBar.reset();
        }
        int curentBlockDimension = 1000000;
        if (!this.isLoggedOn()) {
            curentBlockDimension *= 10;
        }
        while (true) {
            if ((curentBlockDimension /= 10) < 2) {
                return new MethodResult("Server request failed due to a timeout.");
            }
            result = null;
            this.progressBar.printCompletionStatus(this.progressBarI, this.progressBarMax);
            if (price.length == 0) {
                this.progressBarMax = 0;
                return new MethodResult("Wrong length of price vector.");
            }
            if (timeSec.length != price.length && timeSec.length != 0) {
                this.progressBarMax = 0;
                return new MethodResult("Length of price and time vector must be the same.");
            }
            if (timeSec.length == 0) {
                timeSec = new int[price.length];
                int i = 0;
                while (i < price.length) {
                    timeSec[i] = i + 1;
                    ++i;
                }
            }
            int maxBlockDimension = curentBlockDimension;
            double ttt = price.length;
            ttt = ttt / (double)maxBlockDimension + 0.5;
            int numberBlocks = (int)ttt;
            pointer = 0;
            int i = 0;
            while (i < numberBlocks - 1) {
                block36: {
                    double[] resultBlock2;
                    block35: {
                        double[] priceBlock = new double[maxBlockDimension];
                        int[] timeSecBlock = new int[maxBlockDimension];
                        if (timeSec.length != price.length) {
                            this.progressBarMax = 0;
                            return new MethodResult("Length of price and time vector must be the same.");
                        }
                        int j = 0;
                        int localPointer = pointer;
                        while (j < maxBlockDimension) {
                            priceBlock[j] = price[localPointer];
                            timeSecBlock[j] = timeSec[localPointer];
                            ++j;
                            ++localPointer;
                        }
                        try {
                            PriceDataSet data = new PriceDataSet(priceBlock, timeSecBlock);
                        }
                        catch (Exception e) {
                            return new MethodResult(e.getMessage());
                        }
                        resultBlock2 = new double[]{};
                        try {
                            this.clearStatus();
                            Message msg = ClientRequestMessageFactory.createNonparametricComputeRequest(this.getTemplateRegistry(), estimatorType, "false", priceBlock, timeSecBlock, this.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
                            Message responseMsg = this.sendAndAwaitResponse(msg, 300);
                            NonparametricComputeResponse response = ServerResponseMessageParser.parseNonparametricComputeResponse(responseMsg);
                            if (response.getMsgType().equals("OK")) {
                                resultBlock2 = response.getData();
                                break block35;
                            }
                            throw new Exception(response.getMsgBody());
                        }
                        catch (ConnectFailedException e) {
                            MethodResult isRestarted = this.restart();
                            if (isRestarted.hasError()) {
                                return new MethodResult(isRestarted.getErrorMessage());
                            }
                            numberBlocks = -1;
                            break block36;
                        }
                        catch (Exception e) {
                            return new MethodResult(e.getMessage());
                        }
                    }
                    if (result == null) {
                        result = new double[price.length];
                    }
                    int j = 0;
                    int localPointer = pointer;
                    while (j < resultBlock2.length) {
                        result[localPointer] = resultBlock2[j];
                        ++j;
                        ++localPointer;
                    }
                    pointer += maxBlockDimension;
                    this.progressBarI += resultBlock2.length;
                    this.progressBar.printCompletionStatus(this.progressBarI, this.progressBarMax);
                }
                ++i;
            }
            if (numberBlocks == -1) continue;
            double[] priceBlock = new double[price.length - pointer];
            int[] timeSecBlock = new int[price.length - pointer];
            if (timeSec.length != price.length) {
                this.progressBarMax = 0;
                return new MethodResult("Length of price and time vector must be the same.");
            }
            int j = 0;
            int localPointer = pointer;
            while (j < price.length - pointer) {
                priceBlock[j] = price[localPointer];
                timeSecBlock[j] = timeSec[localPointer];
                ++j;
                ++localPointer;
            }
            try {
                PriceDataSet data = new PriceDataSet(priceBlock, timeSecBlock);
            }
            catch (Exception e) {
                return new MethodResult(e.getMessage());
            }
            resultBlock = new double[]{};
            try {
                Message msg = ClientRequestMessageFactory.createNonparametricComputeRequest(this.getTemplateRegistry(), estimatorType, "true", priceBlock, timeSecBlock, this.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
                Message responseMsg = this.sendAndAwaitResponse(msg, 300);
                NonparametricComputeResponse response = ServerResponseMessageParser.parseNonparametricComputeResponse(responseMsg);
                if (response.getMsgType().equals("OK")) {
                    resultBlock = response.getData();
                    break;
                }
                throw new Exception(response.getMsgBody());
            }
            catch (ConnectFailedException e) {
                MethodResult isRestarted = this.restart();
                if (isRestarted.hasError()) {
                    return new MethodResult(isRestarted.getErrorMessage());
                }
                numberBlocks = -1;
                continue;
            }
            catch (Exception e) {
                return new MethodResult(e.getMessage());
            }
            break;
        }
        if (result == null) {
            result = new double[price.length];
        }
        int j = 0;
        int localPointer = pointer;
        while (j < resultBlock.length) {
            result[localPointer] = resultBlock[j];
            ++j;
            ++localPointer;
        }
        this.progressBarI += resultBlock.length;
        this.progressBar.printCompletionStatus(this.progressBarI, this.progressBarMax);
        if (this.progressBarI == this.progressBarMax) {
            this.createCallGroup(1);
        }
        try {
            resultCache = new ArrayCache(result);
            resultTime = new ArrayCache(timeSec);
        }
        catch (IOException e) {
            return new MethodResult(e.getMessage());
        }
        MethodResult resultA = new MethodResult();
        resultA.setData("value", resultCache);
        resultA.setData("time", resultTime);
        return resultA;
    }

    public MethodResult estimateEstimator(String metricType) throws Exception {
        HashMap<String, String> info = new HashMap<String, String>();
        ArrayCache resultValueList = null;
        ArrayCache resultTimeList = null;
        boolean isRun = true;
        boolean isFirstBlock = true;
        double percent = 0.0;
        int[] dimensions = null;
        this.progressBar.printCompletionStatus(percent);
        while (isRun) {
            Message responseMsg;
            Message msg;
            this.clearStatus();
            if (isFirstBlock) {
                resultValueList = new ArrayCache(ArrayCacheType.DOUBLE_VECTOR);
                resultTimeList = new ArrayCache(ArrayCacheType.LONG_VECTOR);
                msg = ClientRequestMessageFactory.createNonparametricComputeRequest(this.getTemplateRegistry(), metricType, "", new double[1], new int[1], this.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
                responseMsg = this.sendAndAwaitResponse(msg, 300);
                isFirstBlock = false;
            } else {
                msg = ClientRequestMessageFactory.createNonparametricComputeRequest(this.getTemplateRegistry(), metricType, "#NEXT#", new double[1], new int[1], this.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
                responseMsg = this.sendAndAwaitResponse(msg, 300);
            }
            TransmitDataRequest response = ServerResponseMessageParser.parseTransmitDataRequest(responseMsg);
            if (response.getMsgType().contains("OK")) {
                Gson gson = new Gson();
                Type mapType = new TypeToken<CalculationStatusMessage>(){}.getType();
                CalculationStatusMessage statusMessg = (CalculationStatusMessage)gson.fromJson(response.getMsgType(), mapType);
                dimensions = statusMessg.getDimension();
                float[] data = response.getDataFloat();
                long[] time = response.getTime();
                resultValueList.writeAsDouble(data);
                resultTimeList.write(time);
                percent = Double.valueOf(response.getMsgBody());
                this.progressBar.printCompletionStatus(percent);
                if (!response.getMsgType().contains("STOP")) continue;
                info = statusMessg.getResultInfo();
                isRun = false;
                continue;
            }
            throw new Exception(response.getMsgBody());
        }
        if (dimensions != null) {
            resultValueList.setDimensions(dimensions);
        }
        MethodResult result = new MethodResult();
        result.setData("value", resultValueList);
        result.setData("time", resultTimeList);
        result.setInfo(info);
        return result;
    }

    public MethodResult estimateTransactional(String metricType, String indexPosition, ArrayList<String> positionList, String params) throws Exception {
        HashMap<String, String> info = new HashMap<String, String>();
        ArrayCache resultValueList = null;
        ArrayCache resultTimeList = null;
        boolean isRun = true;
        boolean isFirstBlock = true;
        double percent = 0.0;
        int[] dimensions = null;
        this.progressBar.printCompletionStatus(percent);
        while (isRun) {
            Message responseMsg;
            this.clearStatus();
            if (isFirstBlock) {
                resultValueList = new ArrayCache(ArrayCacheType.DOUBLE_VECTOR);
                resultTimeList = new ArrayCache(ArrayCacheType.LONG_VECTOR);
                if (indexPosition.length() != 0) {
                    positionList.add(0, indexPosition);
                }
                Gson gson = new Gson();
                String request = gson.toJson(positionList);
                Message msg = ClientRequestMessageFactory.createTransactionalPortfolioComputeRequest(this.getTemplateRegistry(), metricType, request, params, this.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
                responseMsg = this.sendAndAwaitResponse(msg, 300);
                isFirstBlock = false;
            } else {
                Message msg = ClientRequestMessageFactory.createTransactionalPortfolioComputeRequest(this.getTemplateRegistry(), metricType, "#NEXT#", "", this.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
                responseMsg = this.sendAndAwaitResponse(msg, 300);
            }
            TransmitDataRequest response = ServerResponseMessageParser.parseTransmitDataRequest(responseMsg);
            if (response.getMsgType().contains("OK")) {
                Gson gson = new Gson();
                Type mapType = new TypeToken<CalculationStatusMessage>(){}.getType();
                CalculationStatusMessage statusMessg = (CalculationStatusMessage)gson.fromJson(response.getMsgType(), mapType);
                dimensions = statusMessg.getDimension();
                float[] data = response.getDataFloat();
                long[] time = response.getTime();
                resultValueList.writeAsDouble(data);
                resultTimeList.write(time);
                percent = Double.valueOf(response.getMsgBody());
                this.progressBar.printCompletionStatus(percent);
                if (!response.getMsgType().contains("STOP")) continue;
                info = statusMessg.getResultInfo();
                isRun = false;
                continue;
            }
            throw new Exception(response.getMsgBody());
        }
        if (dimensions != null) {
            resultValueList.setDimensions(dimensions);
        }
        MethodResult result = new MethodResult();
        result.setData("value", resultValueList);
        result.setData("time", resultTimeList);
        result.setInfo(info);
        return result;
    }

    public MethodResult getAllSymbolsList() throws Exception {
        Message msg = ClientRequestMessageFactory.createTransactionalPortfolioComputeRequest(this.getTemplateRegistry(), "ALL_SYMBOLS", "", "", this.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
        Message responseMsg = this.sendAndAwaitResponse(msg, 300);
        TransmitDataRequest response = ServerResponseMessageParser.parseTransmitDataRequest(responseMsg);
        MethodResult result = new MethodResult();
        if (!response.getMsgType().contains("OK")) {
            throw new Exception(response.getMsgBody());
        }
        byte[] data = response.getDataFloatByte();
        data = Snappy.uncompress((byte[])data, (int)0, (int)data.length);
        Map map = (Map)SerializationUtils.deserialize((byte[])data);
        result.setStringArray("id", (String[])map.get("id"));
        result.setStringArray("description", (String[])map.get("description"));
        result.setStringArray("exchange", (String[])map.get("exchange"));
        return result;
    }

    public MethodResult getComputeTimeLeft() {
        int i = 0;
        while (i < 3) {
            try {
                Message msg = ClientRequestMessageFactory.createTransactionalPortfolioComputeRequest(this.getTemplateRegistry(), "TIME_LEFT", "", "", this.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
                Message responseMsg = this.sendAndAwaitResponse(msg, 300);
                TransmitDataRequest response = ServerResponseMessageParser.parseTransmitDataRequest(responseMsg);
                MethodResult result = new MethodResult();
                if (!response.getMsgType().contains("OK")) {
                    throw new Exception(response.getMsgBody());
                }
                String[] data = response.getMsgBody().split("#");
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("timeLeft", data[0]);
                info.put("timeMax", data[1]);
                result.setInfo(info);
                return result;
            }
            catch (Exception e) {
                MethodResult result = this.processException(e);
                if (result != null) {
                    return result;
                }
                ++i;
            }
        }
        return new MethodResult("Failed to complete estimation procedure - cannot connect to server. Server request failed due to a timeout.");
    }

    private MethodResult processException(Exception e) {
        if (e instanceof ConnectFailedException) {
            MethodResult isRestarted = this.restart();
            if (isRestarted.hasError()) {
                this.resetProgressBar();
                return new MethodResult(isRestarted.getErrorMessage());
            }
            return null;
        }
        if (e.getMessage() == null || e.getMessage().contains("No data in cache") || e.getMessage().contains("null")) {
            MethodResult isRestarted = this.restart();
            if (isRestarted.hasError()) {
                this.resetProgressBar();
                return new MethodResult(isRestarted.getErrorMessage());
            }
            return null;
        }
        if (e.getMessage() == null) {
            Console.writeStackTrace(e);
            return new MethodResult("Unknown error.");
        }
        this.resetProgressBar();
        return new MethodResult(e.getMessage());
    }

    private Message sendAndAwaitResponse(Message request, int timeoutSec) throws Exception {
        if (!this.isConnected) {
            throw new ConnectFailedException();
        }
        try {
            this.out.writeMessage(request);
        }
        catch (Exception e) {
            throw new ConnectFailedException();
        }
        ClientMessage clientMessage = this.clientMessageQueue.poll(timeoutSec, TimeUnit.SECONDS);
        this.clientMessageQueue.clear();
        if (clientMessage == null) {
            throw new ConnectFailedException();
        }
        if (clientMessage == null || clientMessage.isEmpty()) {
            throw new ConnectFailedException();
        }
        if (clientMessage.isRejected()) {
            Reject reject = ServerResponseMessageParser.parseReject(clientMessage.getMessage());
            throw new Exception(reject.getText());
        }
        return clientMessage.getMessage();
    }

    private void sendHeartbeat(String testReqId) {
        Message logoutMsg = ClientRequestMessageFactory.createHeartbeat(this.templateRegistry, this.nextOutboundMsgSequenceNumber(), testReqId);
        this.out.writeMessage(logoutMsg);
    }

    private TemplateRegistry getTemplateRegistry() throws Exception {
        if (this.templateRegistry == null) {
            throw new ConnectFailedException();
        }
        return this.templateRegistry;
    }

    private FastMessageType getMessageType(Message msg) {
        String msgTypeCode = msg.getString("MessageType");
        FastMessageType fastMsgType = FastMessageType.getFastMessageType(msgTypeCode);
        return fastMsgType;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getTemplatesFileName() {
        return this.templatesFileName;
    }

    public void setTemplatesFileName(String templatesFileName) {
        this.templatesFileName = templatesFileName;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public void setMessageLoggingEnabled(boolean isMessageLoggingEnabled) {
        this.isMessageLoggingEnabled = isMessageLoggingEnabled;
    }

    public boolean isMessageLoggingEnabled() {
        return this.isMessageLoggingEnabled;
    }

    public boolean isLoggedOn() {
        return this.isLoggedOn;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public int nextOutboundMsgSequenceNumber() {
        return this.outboundMsgSeqNum++;
    }

    public int getOutboundMsgSequenceNumber() {
        return this.outboundMsgSeqNum++;
    }

    public boolean isDebugModeEnabled() {
        return this.debugModeEnabled;
    }

    public void setDebugModeEnabled(boolean debugModeEnabled) {
        this.debugModeEnabled = debugModeEnabled;
    }

    public String getStatus() {
        return this.callStatus.toString();
    }

    protected void finalize() throws Throwable {
        this.stop();
        super.finalize();
    }

    private class HeartbeatMonitor
    implements Runnable {
        private HeartbeatMonitor() {
        }

        @Override
        public void run() {
            while (!Thread.interrupted()) {
                try {
                    ServiceMessage serviceMessage = (ServiceMessage)ClientConnection.this.serviceMessageQueue.poll(30L, TimeUnit.SECONDS);
                    if (serviceMessage == null) {
                        ClientConnection.this.clientMessageQueue.offer(new ClientMessage(null, false, true));
                        continue;
                    }
                    if (!serviceMessage.isTerminated()) continue;
                }
                catch (Exception e) {}
                break;
            }
        }
    }

    private class InboundMessageWorker
    implements Runnable {
        private InboundMessageWorker() {
        }

        @Override
        public void run() {
            try {
                ClientConnection.this.logger.debug((Object)"Started inbound message logger thread");
                while (true) {
                    Message msg;
                    if ((msg = ClientConnection.this.in.readMessage()) == null) {
                        ClientConnection.this.logger.debug((Object)"End of input stream. Exiting from inbound message worker thread");
                        break;
                    }
                    FastMessageType responseMessageType = ClientConnection.this.getMessageType(msg);
                    ClientConnection.this.serviceMessageQueue.offer(new ServiceMessage(System.currentTimeMillis()));
                    switch (responseMessageType) {
                        case TEST_REQUEST: {
                            TestRequest testRequest = ServerResponseMessageParser.parseTestRequest(msg);
                            ClientConnection.this.sendHeartbeat(testRequest.getTestReqID());
                            break;
                        }
                        case HEARTBEAT: {
                            break;
                        }
                        case LOGON: {
                            ClientConnection.this.isLoggedOn = true;
                            ClientConnection.this.clientMessageQueue.offer(new ClientMessage(msg));
                            break;
                        }
                        case LOGOUT: {
                            ClientConnection.this.isLoggedOn = false;
                            ClientConnection.this.clientMessageQueue.offer(new ClientMessage(msg));
                            break;
                        }
                        case REJECT: {
                            ClientConnection.this.clientMessageQueue.offer(new ClientMessage(msg, true, false));
                            break;
                        }
                        case GET_REMAINING_TRAFFIC_RESPONSE: {
                            ClientConnection.this.clientMessageQueue.offer(new ClientMessage(msg));
                            break;
                        }
                        case NON_PARAM_METRIC_RESPONSE: {
                            ClientConnection.this.clientMessageQueue.offer(new ClientMessage(msg));
                            break;
                        }
                        case PORTFOLIO_ESTIMATION_RESPONSE: {
                            ClientConnection.this.clientMessageQueue.offer(new ClientMessage(msg));
                            break;
                        }
                        default: {
                            ClientConnection.this.clientMessageQueue.offer(new ClientMessage(msg));
                        }
                    }
                    if (!ClientConnection.this.isMessageLoggingEnabled) continue;
                    ClientConnection.this.logger.info((Object)("Recieved message: " + msg.toString()));
                }
            }
            catch (FastException e) {
                ClientConnection.this.isLoggedOn = false;
                ClientConnection.this.isConnected = false;
                ClientConnection.this.logger.info((Object)"Connection was terminated");
            }
        }
    }
}

