% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.R
\name{position_limit_constraint}
\alias{position_limit_constraint}
\title{constructor for filter_constraint}
\usage{
position_limit_constraint(
  type = "position_limit",
  filter_name = NULL,
  enabled = TRUE,
  message = FALSE,
  ...
)
}
\arguments{
\item{type}{character type of the constraint}

\item{filter_name}{either a function to apply, or a name of a function to apply}

\item{enabled}{TRUE/FALSE}

\item{message}{TRUE/FALSE. The default is message=FALSE. Display messages if TRUE.}

\item{\dots}{any other passthru parameters to specify position limit constraints}
}
\value{
an object of class 'position_limit_constraint'
}
\description{
This function is called by add.constraint when type="filter" is specified, \code{\link{add.constraint}}
}
\details{
Allows the user to specify a filter function which will take returns, weights,
and constraints as inputs, and can return a modified weights vector as output.

Fundamentally, it could be used to filter out certain assets, or to ensure 
that they must be long or short.

Typically, filter functions will be called by the random portfolio simulation
function or via the fn_map function.
}
\examples{
data(edhec)
ret <- edhec[, 1:4]

pspec <- portfolio.spec(assets=colnames(ret))

pspec <- add.constraint(portfolio=pspec, type="position_limit", max_pos=3)
pspec <- add.constraint(portfolio=pspec, type="position_limit", max_pos_long=3, max_pos_short=1)
}
\seealso{
\code{\link{add.constraint}}
}
\author{
Ross Bennett
}
