% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popdynfun.r
\name{init.popgensim}
\alias{init.popgensim}
\title{Initialise a spatial meta-population for a popgen simulation}
\usage{
init.popgensim(n.pops, n.ind, sex.ratio, n.loci, n.allels, locs = NULL,
  n.cov = 3)
}
\arguments{
\item{n.pops}{number of subpopulations}

\item{n.ind}{number of individuals per subpopulation}

\item{sex.ratio}{sex ratio of males and females}

\item{n.loci}{number of loci}

\item{n.allels}{number of maximal alleles per loci}

\item{locs}{coordinates of the subpopulations, provided as a row named data.frame(x=, y=) with n.pops rows.[Only used to name the subpopulations by row.names(locs). If not provided subpopulations are simply numbered.}

\item{n.cov}{number of covariates (currenlty do not change, defaults to 3. In future versions covariates such as age etc. will be implemented)}
}
\value{
a simpops object (to be used in run.popgensim ), which is a list of subpopulations. Each subpopulation consists of a data.frame with a row for each individual (coding the covariates and genetic make-up).
}
\description{
This functions initialises a time-forward, agent-based and spatiallly explicit genetic meta-population simulation
}
\details{
To set up a population we have to specify the following parameters: n.pops defines the number of subpopulations and n.ind the number of individuals within subpopulations (carrying capacity). In the current implementaiton all subpopulations have the same number of individuals. sex.ratio determines the proportion of females in a subpopulation. finaly the number of loci and number of alleles need to be specified. locs is used to name the populations. For simplicity the names are provided via a data.frame of x and y coordinates (as they normally come from a genind object)
}
\examples{
init.popgensim(n.pops = 5, n.ind=8, sex.ratio = 0.25, n.loci = 4, n.allels = 7, n.cov = 3)
}
\seealso{
\code{\link{run.popgensim}}
}
