% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downsizing_general_design.R
\name{downsizing_general_design}
\alias{downsizing_general_design}
\title{Downsize a general design to a specific design}
\usage{
downsizing_general_design(poped.db)
}
\arguments{
\item{poped.db}{A PopED database}
}
\value{
A list containing:
\item{ni}{A vector of the number of samples in each group.}
\item{xt}{A matrix of sample times.  Each row is a vector of sample times for a group.}
\item{model_switch}{A matrix that is the same size as xt, specifying which model each sample belongs to.}
\item{x}{A matrix for the discrete design variables.  Each row is a group.}
\item{a}{A matrix of covariates.  Each row is a group.}
\item{bpop}{A matrix of fixed effect parameter values.}
}
\description{
Function takes a design with potentially empty design 
variables and rescues the design so that a FIM can be calculated using \code{\link{mftot}}.
}
\seealso{
Other poped_input: 
\code{\link{convert_variables}()},
\code{\link{create.poped.database}()},
\code{\link{create_design_space}()},
\code{\link{create_design}()},
\code{\link{poped.choose}()}
}
\concept{poped_input}
\keyword{internal}
