% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PolynomF.R
\name{poly_calc}
\alias{poly_calc}
\alias{poly_from_zeros}
\alias{poly_from_roots}
\alias{poly.from.roots}
\alias{poly_from_values}
\title{Lagrange interpolation polynomial}
\usage{
poly_calc(x, y, tol = sqrt(.Machine$double.eps),
  lab = dimnames(y)[[2]])

poly_from_zeros(...)

poly_from_roots(...)

poly.from.roots(...)

poly_from_values(x, y, tol = sqrt(.Machine$double.eps),
  lab = dimnames(y)[[2]])
}
\arguments{
\item{x}{A numeric vector of x-points at which the y-values are specified.}

\item{y}{Either a numeric vector of the same length as \code{x} or a numeric
matrix with rows matching the length of \code{x}.  If \code{y} is
missing (not specified) then a polynomial with zero at \code{x} is
returned.}

\item{tol}{A numeric tolerance for duplicated \code{x} values.}

\item{lab}{A character string vector of names for the list result when \code{y} is a matrix.}

\item{...}{A list of specified zeros (for subsidiary functions)}
}
\value{
An interpolation polynomial, or list of interpolating polynomials.
}
\description{
Calculate the Lagrange interpolation polynomial, or list of polynomials, given
a set of (x, y) points to fit
}
\examples{
(p <- poly_calc(0:5)) ## same as poly_from_zeros(0:5)
(p <- poly_calc(0:5, exp(0:5)))
plot(p)
curve(exp, add = TRUE, col = "red")
}
