% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VDJ_GEX_clonal_lineage_clusters.R
\name{VDJ_GEX_clonal_lineage_clusters}
\alias{VDJ_GEX_clonal_lineage_clusters}
\title{Platypus V2 lineage - GEX integration utility}
\usage{
VDJ_GEX_clonal_lineage_clusters(
  VDJ_GEX_integrate.output,
  VDJ_clonal_lineages.output
)
}
\arguments{
\item{VDJ_GEX_integrate.output}{The output from the VDJ_GEX_integrate function that is performed on the VDJ_per_clone level. This involves a nested list where the outer list corresponds to the repertoire and inner lists correspond to specific clones based on the clonotyping strategy.}

\item{VDJ_clonal_lineages.output}{Output from VDJ_clonal_lineages. This should be nested list, with the outer list element corresponding to the individual repertoire and the inner list corresponding to individual clonal lineages based on the initial clonotyping strategy in the form of a dataframe with either Seq or Name. The Name currently contains the barcode following the last "_".}
}
\value{
a nested list in the identical format to the VDJ_clonal_lineages.output but the name of each sequence will have been changed to include the transcriptional cluster corresponding to that barcode from the GEX library. This requires first running the
}
\description{
only Platypus v2 Integrates the transcriptional cluster information into the clonal lineages. This requires that automate_GEX, VDJ_clonal_lineages, and VDJ_GEX_integrate have already been ran. The transcriptional cluster will be added to the end of the Name for each sequence.
}
\examples{
\dontrun{
clonal_lineages <- VDJ_clonal_lineages(call_MIXCR.output=call_MIXCR_output
, VDJ_extract_germline.output=VDJ_extract_germline_output
,as.nucleotide=FALSE,with.germline=TRUE)
}

}
