% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VDJ_reclonotype_list_arrange.R
\name{VDJ_reclonotype_list_arrange}
\alias{VDJ_reclonotype_list_arrange}
\title{Only Platypus v2 Organizes the top N genes that define each Seurat cluster and converts them into a single dataframe. This can be useful for obtaining insight into cluster-specific phenotypes.}
\usage{
VDJ_reclonotype_list_arrange(
  VDJ_clonotype.output,
  VDJ_analyze.output,
  Platypus_list.object
)
}
\arguments{
\item{VDJ_clonotype.output}{The output object from the VDJ_clonotype function. The column of the merged nucleotide clonotype IDs will be used to rearrange the new object.}

\item{VDJ_analyze.output}{The output from the initial VDJ_analyze, containing clonotype information based on nucleotide sequence.}

\item{Platypus_list.object}{The new list object from one of Platypus functions (for example, clonal lineages, VDJ_per_clne, etc) that should be merged based on the VDJ_clonotype output structure. nested list structure, where outer list corresponds to repertoire and the inner list corresponds to clones (on the nucleotide level).}
}
\value{
Returns a dataframe in which the top N genes defining each cluster based on differential expression are selected.
}
\description{
Only Platypus v2 Organizes the top N genes that define each Seurat cluster and converts them into a single dataframe. This can be useful for obtaining insight into cluster-specific phenotypes.
}
\examples{
\dontrun{
checking_vdj_reclono <- VDJ_reclonotype_list_arrange(
VDJ_clonotype.output = repertoire_reclonotype
,VDJ_analyze.output = repertoire_list
,Platypus_list.object = repertoire_vdj_per_clone)
}
}
