% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fwer_critical.r
\name{fwer_critical}
\alias{fwer_critical}
\title{Calculate the critical value and the marginal type-I error rate}
\usage{
fwer_critical(ntrt, fwer, corMat, seed = 123)
}
\arguments{
\item{ntrt}{the number of experimental arms in the trial}

\item{fwer}{the family-wise error rate (FWER) to be controlled, default to be the same
throughout the trial}

\item{corMat}{the correlation matrix of the Z-test statistics}

\item{seed}{an integer for random number generation for numerically evaluating integration, default = 123}
}
\value{
\verb{    }\emph{pairwise_alpha} the marginal type-I error rate for the comparison between
any of the experimental arm and its corresponding control

\verb{    }\emph{critical_val}, the critical value for the comparison between any of
the experimental arm and the corresponding controls

Other values returned are inputs.
}
\description{
Calculate the critical value and the marginal type-I error rate given the number of experimental
arms, the family-wise type I error rate and the correlation matrix of the z-statistics.
}
\details{
Use the number of experimental arms, the family-wise type I error rate and the correlation
matrix of the Z-test statistics to calculate the marginal type I error rate and the critical value.
}
\examples{

corMat1 <- cor.mat(K=2, M = 2, n=107, n0=198, n0t = 43)$cormat
fwer_critical(ntrt=4, fwer=0.025, corMat=corMat1)

#$ntrt
#[1] 4

#$fwer
#[1] 0.025

#$corMat
#      [,1]      [,2]      [,3]      [,4]
#[1,] 1.0000000 0.3508197 0.2746316 0.2746316
#[2,] 0.3508197 1.0000000 0.2746316 0.2746316
#[3,] 0.2746316 0.2746316 1.0000000 0.3508197
#[4,] 0.2746316 0.2746316 0.3508197 1.0000000

#$pairwise_alpha
#[1] 0.006657461

#$critical_val
#[1] 2.475233

}
\references{
\verb{    }Dunnett, C. W. (1955). A multiple comparison procedure for comparing
several treatments with a control. Journal of the American Statistical
Association, 50(272), 1096-1121.
}
\author{
\verb{    }Xiaomeng Yuan, Haitao Pan
}
