% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{PrepareLibrary}
\alias{PrepareLibrary}
\title{function PrepareLibrary}
\usage{
PrepareLibrary(info.dir = "Info/", bed.filename = "lungcolonV2.bed.txt",
  snp.filename = "ExAC.r0.3.sites.vep.vcf.gz", snp.extra = c("chr4:1807909",
  "chr7:140481511", "chr18:48586344", "chr14:105246474", "chr19:1223055"),
  output.name = "positions_ranges.rda", load.from.broad.insitute = FALSE)
}
\arguments{
\item{info.dir, }{char, name of the folder containing the library information files (default 'Info/')}

\item{bed.filename, }{char, name of a BED table (tab-delimited) describing the Panel (with first 3 columns: "chr" (ex:chr1), "start position" (ex:115252190), "end position" (ex:115252305), i.e. the Ion AmpliSeq™ Colon and Lung Cancer Research Panel v2 (default 'lungcolonV2.bed.txt' as provided in the inst/extdata/Info folder of the package).}

\item{snp.filename, }{char, name of the vcf file describing known SNP positions, obtained from ftp://ftp.broadinstitute.org/pub/ExAC_release/release0.3/ExAC.r0.3.sites.vep.vcf.gz (default 'ExAC.r0.3.sites.vep.vcf.gz'). It requires a corresponding TBI file to be in the same folder (obtained from ftp://ftp.broadinstitute.org/pub/ExAC_release/release0.3/ExAC.r0.3.sites.vep.vcf.gz.tbi)}

\item{snp.extra, }{a vector of char, a vector of extra known snp positions manually curated (ex:"chrN:XXXXXXXXX")}

\item{output.name, }{char, filename to save \code{pos_ind} and \code{pos_snp} in \code{info.dir} (default 'positions_ranges.rda')}

\item{load.from.broad.insitute, }{boolean, if TRUE load \code{snp.filename} from Broad Institute ftp server otherwise use the file positions_ranges_broad.rda (default FALSE)}
}
\value{
Save the following variables in a .rda file defined by \code{output.name} in the folder defined by \code{info.dir}:
\itemize{
\item \code{pos_ranges}, a GRanges descriptor of amplicon positions
\item \code{pos_ind}, a vector of char "chrN:XXXXXXXXX", defining ALL index positions
\item \code{pos_snp}, a vector of char "chrN:XXXXXXXXX", defining SNP positions
}
}
\description{
Define the Genomic Ranges and Genomic Positions covered by the AmpliSeq™ Panel to include in the study and define SNP positions to exclude from the study.
Trimming amplicon ends is performed if specified. This function is mostly useful if you want to add some SNP positions which are not existing in the
positions_ranges.rda file provided within the package. It is provided to be able to reconstruct \code{positions_ranges.rda} data.
}
\examples{
   bad.pos = "chr7:15478"
   PrepareLibrary(info.dir='./',snp.extra=bad.pos)


}
\author{
N. Pécuchet, P. Laurent-Puig and Y. Rozenholc
}
\references{
\emph{Analysis of base-position error rate of next-generation sequencing to detect tumor mutations in circulating DNA} N. Pécuchet, Y. Rozenholc, E. Zonta, D. Pietraz, A. Didelot, P. Combe, L. Gibault, J-B. Bachet, V. Taly, E. Fabre, H. Blons, P. Laurent-Puig in \emph{Clinical Chemistry}
}
\seealso{
positions_ranges,
}

