
# Helper function for coercing JSON output into data.frame for a single pet record. 
# Used by methods pet_get() and pet_getRandom().
pet_record = function(r) {
  records <- names(r)
  recordlist <- list()
  
  for (i in 1:length(records)) {

    if (length(records[i]) > 0 & !is.null(records[i]) & !is.logical(records[i]) & records[i] == 'options') {
      ropt <- r$options$option

      if (is.data.frame(ropt)) {
        statuses <- data.frame(as.matrix(t(ropt)), stringsAsFactors = FALSE)
      }

      else if (is.list(ropt)) {
        statuses <- data.frame(status.1=ropt[[1]], stringsAsFactors = FALSE)
      }

      else if (is.null(ropt)) {
        statuses <- data.frame(status.1='None', stringsAsFactors = FALSE)
      }

      colnames(statuses) <- paste('status.', gsub('X', '', colnames(statuses)), sep = '')
      recordlist[[i]] <- statuses
    }

    else if (length(records[i]) > 0 & !is.null(records[i]) & !is.logical(records[i]) & records[i] == 'media') {

      if (!is.data.frame(records[i])) {
        photos <- data.frame(photo.1=NA)
      }

      else {
        photos <- data.frame(t(r$media$photos$photo$`$t`), stringsAsFactors = FALSE)
        colnames(photos) <- paste('photo.', colnames(photos), sep = '')
      }

      recordlist[[i]] <- photos
    }

    else if (length(records[i]) > 0 & !is.null(records[i]) & !is.logical(records[i]) & records[i] == 'contact') {
      con <- r$contact

      contactnames <- names(con)
      contactinfo <- list()

      for (i in contactnames) {
        if (!is.na(names(con[i][[1]][1]))) {
          contactinfo[[i]] <- con[i][[1]]$`$t`
        }
      }
      recordlist[[i]] <- data.frame(contactinfo, stringsAsFactors = FALSE)
    }

    else if (length(records[i]) > 0 & !is.null(records[i]) & !is.logical(records[i]) & records[i] == 'breeds') {
      breeds <- r$breeds$breed

      breeds.df <- data.frame(t(breeds), stringsAsFactors = FALSE)
      colnames(breeds.df) <- paste('breed', gsub('X', '', colnames(breeds.df)), sep = '.')
      recordlist[[i]] <- breeds.df
    }

    else {
      df <- tryCatch(
        {
          data.frame(r[i][[1]][[1]], stringsAsFactors = FALSE)
        },
        error = function(cond) {
          data.frame(NA)
        }
      )
      colnames(df) <- names(r[i])
      recordlist[[i]] <- df
    }
  }

  pet.df <- data.frame(recordlist, stringsAsFactors = FALSE)
  colnames(pet.df) <- gsub('X.t', '', colnames(pet.df))
  
  pet.df <- dplyr::mutate_if(pet.df, is.factor, as.character)
  
  return(pet.df)
}


# Helper function for coercing JSON output from Petfinder database into data.frame.
# Used by pet method pet.find when returning more than one record.
pet_records_df = function(r) {
  
  # Options
  
  pet_df <- r$petfinder$pets$pet
  pet_opt <- pet_df$options.option
  
  statuses <- list()
  
  for (i in 1:length(pet_df$options.option)) {
    statuses[i] <- list(pet_opt[i][[1]])
    if (!is.null(statuses[i][[1]])) {

      statuses[[i]] <- data.frame(t(statuses[[i]]))
    }
    else {
      statuses[[i]] <- data.frame(t(NA))
    }
  }

  # Breeds
  
  pet_breeds <- pet_df$breeds.breed

  breeds <- list()

  for (i in 1:length(pet_breeds)) {
    breeds[i] <- list(pet_breeds[i][[1]])
    if (is.data.frame(breeds[i][[1]])) {
      breeds[[i]] <- data.frame(t(breeds[[i]]))
    }
    else {
      df <- data.frame(pet_breeds[i][[1]])
      colnames(df) <- 'X1'
      breeds[[i]] <- df
    }
  }
  
  # Photos
  
  media <- pet_df$media.photos.photo
  
  photos <- list()
  
  for (i in 1:length(media)) {
    photos[i] <- list(media[i][[1]]$`$t`)
    
    if (is.null(photos[i][[1]])) {
      photos[[i]] <- data.frame(photo1=NA)
    } 
    else {
      photos[[i]] <- data.frame(t(photos[[i]]))  
    }
  }
  
  photos <- plyr::rbind.fill(photos)
  statuses <- plyr::rbind.fill(statuses)
  breeds <- plyr::rbind.fill(breeds)
  
  colnames(photos) <- paste0('photo.', c(1:length(colnames(photos))))
  colnames(statuses) <- paste0('status.', c(1:length(colnames(statuses))))
  colnames(breeds) <- paste0('breed.', c(1:length(colnames(breeds))))
  
  pet_df$options.option <- NULL
  pet_df$media.photos.photo <- NULL
  pet_df$breeds.breed <- NULL
  
  colnames(pet_df) <- gsub(x = colnames(pet_df), pattern = '\\.\\$t', replacement = '')

  pet_df <- cbind(pet_df, photos, statuses, breeds)
  
  pet_df <- dplyr::mutate_if(pet_df, is.factor, as.character)
  
  return(pet_df)
}


shelter_records_to_df = function(r) {
  
  df <- data.frame(lapply(r, function(x) {
    
    if (is.null(dim(x))) {
      tryCatch(
        x[[1]],
        error = function(cond) {
          x <- NA
        }
      )
    }
    
    else if (dim(x)[2] == 0) {
      x <- NA
    }
    
    else {
      x
    }
  }), stringsAsFactors = FALSE)

  colnames(df) <- gsub(colnames(df), pattern = '\\..t', replacement = '')
  colnames(df) <- gsub(colnames(df), pattern = 'shelter\\.', replacement = '')
  
  df <- dplyr::mutate_if(df, is.factor, as.character)
  
  return(df)
}