% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixDataMethods.R
\name{as.ExpressionSet.matrixData}
\alias{as.ExpressionSet.matrixData}
\title{Coerces a MatrixData into an ExpressionSet}
\usage{
as.ExpressionSet.matrixData(mdata)
}
\arguments{
\item{mdata}{a \code{\link[PerseusR]{matrixData}} object}
}
\value{
returns an \code{\link[Biobase]{ExpressionSet}} object
}
\description{
Coerces a MatrixData object into an ExpressionSet object
}
\details{
function to convert a \code{\link[PerseusR]{matrixData}} \code{\link[Biobase]{ExpressionSet}}
}
\examples{

\donttest{
mD <- matrixData(
main=data.frame(a=1:3, b=6:8),
annotCols=data.frame(b=c('a','b','c')),
annotRows=data.frame(x=factor(c('1','1'))))

eSet <- as(mD, "ExpressionSet")
print(eSet)
}
}
