% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PerMallows.R
\name{marginal}
\alias{marginal}
\title{Compute the marginal probability, GMM under the Hamming distance}
\usage{
marginal(h, theta)
}
\arguments{
\item{h}{n dimensional distance decomposition vector where h_j = 0 means that $j$ is a fixed point, 
h_j = 1 means that $j$ is an unfixed point and otherwise $j$ is not known}

\item{theta}{n dimensional distance decomposition vector with the dispersion parameters}
}
\value{
The marginal probability
}
\description{
Compute the marginal probability, GMM under the Hamming distance, 
of a distance decomposition vector for which some positions are known and some are not
}
\examples{
marginal(c(1,0,1,NA,NA), c(0.1, 0.3, 0.7, 0.1, 1))
marginal(c(NA,0,1,NA,NA,0), c(0.1, 0.3, 0.7, 0.1, 0.7, 1))
}
\references{
"Ekhine Irurozki, Borja Calvo, Jose A. Lozano (2016). PerMallows: An R Package for Mallows and Generalized Mallows Models. Journal of Statistical Software, 71(12), 1-30. doi:10.18637/jss.v071.i12"
}

