% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mz.R
\name{mz}
\alias{mz}
\title{Calculate the m/z for peptides.}
\usage{
mz(seq, charge = 2, label = "none", aaShift = NULL, cysteins = 57.021464)
}
\arguments{
\item{seq}{An amino-acids sequence, in one letter code.}

\item{charge}{The net charge for which the m/z should be calculated}

\item{label}{Set a predefined heavy isotope label. Accepts "none", "silac_13c", "silac_13c15n" and "15n". Overwrites input in \code{aaShift}.}

\item{aaShift}{Define the mass difference in Dalton of given amino acids as a named vector. Use the amino acid one letter code as names and the mass shift in Dalton as values.}

\item{cysteins}{Define the mass shift in Dalton of blocked cysteins. Defaults to 57.021464, for cysteins blocked by iodoacetamide.}
}
\description{
This function calculates the (monoisotopic) mass over charge ratio (m/z) for peptides, as measured in mass spectrometry.
}
\examples{
mz("EGVNDNECEGFFSAR")
mz("EGVNDNECEGFFSAR", aaShift = c(K = 6.020129, R = 6.020129))
mz("EGVNDNECEGFFSAR", label = "silac_13c", cysteins = 58.005479)

}
