\name{elongationEstimation}
\alias{elongationEstimation}
\alias{C_elongationEstimation}
\title{Shifting the positive strand vector and compute an overlap score to 
estimate the optimal elongation size for the fragments}
\description{
This function helps to estimate the average lag between two numeric vectors
(typically piled scores of reads aligned on negative and positive strands of
each chromosome). It is namely used by Pasha pipeline to infer the average DNA
fragments size of sequenced samples.
}
\usage{
elongationEstimation(piledValuesPlus, piledValuesMinus, stepShift)
}
\arguments{
  \item{piledValuesPlus}{Numeric vector containing the piled score for the
  positive strand of the current chromosome}
  \item{piledValuesMinus}{Numeric vector containing the piled score for the
  negative strand of the current chromosome}
  \item{stepShift}{vector of positive integer specifying the shifting values 
  that have to be tested}
}
\details{
This function takes as input two numeric vectors and a set of 'shifting'
values.
The two input vectors are aligned and an element-by-element multiplication is
computed. The sum of these multiplication represent an overlap estimation of
signal between the two vectors. 
This score is computed iteratively after shifting the relative alignment of the
input vectors by all values of 'shifting'.
It finally returns a vector of 'overlap' scores (covering every shifting value
specified).
In theory the vectors should be of the same size but the wrapper takes care to 
pad with 0s if this constraint is not respected.
}
\value{
A vector of overlap scores generated by the function.
}
\author{Romain Fenouil}
\examples{
# Create a very large vector of random values
a <- rnorm(1000000)

# Copy this vector but add 150 0s in front (shift)    
b <- c(rep(0,150),a)

# Estimate the overlap scores for shifting values between 50 and 200
shiftEstimate <- seq(50,200,by=10)
overlapScores <- elongationEstimation(a,b,shiftEstimate)

# Show the scores evolution
plot(shiftEstimate, overlapScores)

# Show the max value (150)
abline(v=shiftEstimate[which.max(overlapScores)], col='red')
}
