% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{rPareto}
\alias{rPareto}
\title{Simulation of the Pareto Distribution}
\usage{
rPareto(n, t, alpha, truncation = NULL)
}
\arguments{
\item{n}{Numeric. Number of observations.}

\item{t}{Numeric vector. Thresholds of the Pareto distributions}

\item{alpha}{Numeric vector. Pareto alphas of the Pareto distributions.}

\item{truncation}{NULL or Numeric vector. If \code{truncation} is not \code{NULL} and \code{truncation > t}, then the Pareto distribution is truncated at \code{truncation} (resampled Pareto)}
}
\value{
A vector of \code{n} samples from the (truncated) Pareto distribution with parameters \code{t} and \code{alpha}
}
\description{
Generates random deviates of a Pareto distribution
}
\examples{
rPareto(100, 1000, 2)
rPareto(100, 1000, 2, truncation = 2000)
rPareto(100, t = c(1, 10, 100, 1000, 10000), alpha = c(1, 2, 4, 8, 16))

}
