% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PanelEstimate.R
\name{PanelEstimate}
\alias{PanelEstimate}
\title{PanelEstimate}
\usage{
PanelEstimate(
  sets,
  data,
  number.iterations = 1000,
  df.adjustment = FALSE,
  confidence.level = 0.95,
  moderator = NULL,
  se.method = "bootstrap",
  pooled = FALSE,
  include.placebo.test = FALSE,
  parallel = FALSE,
  num.cores = 1
)
}
\arguments{
\item{sets}{A \code{PanelMatch} object attained via the
\code{PanelMatch()} function.}

\item{data}{The same time series cross sectional data set provided to the \code{PanelMatch()} function used to produce
the matched sets.}

\item{number.iterations}{If using bootstrapping for calculating standard errors, this is the number of bootstrap iterations. Provide as integer. If \code{se.method} is not equal to "bootstrap", this argument has no effect.}

\item{df.adjustment}{A logical value indicating whether or not a
degree-of-freedom adjustment should be performed for the standard error
calculation. The default is \code{FALSE}. This parameter is only available for the bootstrap method of standard error calculation.}

\item{confidence.level}{A numerical value specifying the confidence level and range of interval
estimates for statistical inference. The default is .95.}

\item{moderator}{The name of a moderating variable, provided as a character string. If a moderating variable is provided,the returned object will be a list of \code{PanelEstimate} objects. The names of the list will reflect the different values of the moderating variable. More specifically, the moderating variable values will be converted to syntactically proper names using \code{make.names()}.}

\item{se.method}{Method used for calculating standard errors, provided as a character string. Users must choose between "bootstrap", "conditional", and "unconditional" methods. Default is "bootstrap". "bootstrap" uses a block bootstrapping procedure to calculate standard errors. The conditional method calculates the variance of the estimator, assuming independence across units but not across time. The unconditional method also calculates the variance of the estimator analytically, but makes no such assumptions about independence across units. When the quantity of interest is "att", "atc", or "art", all methods are available. Only "bootstrap" is available for the ate. If \code{pooled} argument is TRUE, then only bootstrap is available.}

\item{pooled}{Logical. If TRUE, estimates and standard errors are returned for treatment effects pooled across the entire lead window. Only available for \code{se.method = ``bootstrap''}}

\item{include.placebo.test}{Logical. If TRUE, a placebo test is run and returned in the results. The placebo test uses the same specifications for calculating standard errors as the main results. That is, standard errors are calculated according to the user provided \code{se.method} and \code{confidence.level} arguments (and, if applicable, parallelization specifications). If these are invalid for some reason, an error will be thrown.}

\item{parallel}{Logical. If TRUE and \code{se.method = ``bootstrap''}, bootstrap procedure will be parallelized. Default is FALSE. If \code{se.method} is not set to \code{bootstrap}, this option does nothing.}

\item{num.cores}{Integer. Specifies the number of cores to use for parallelization. If \code{se.method = ``bootstrap''} and \code{parallel = TRUE}, then this option will take effect. Otherwise, it will do nothing.}
}
\value{
\code{PanelEstimate} returns a list of class
`PanelEstimate' containing the following components:
\item{estimates}{the point estimates of the quantity of interest for the lead periods specified}
\item{se.method}{The method used to calculate standard errors. This is the same as the argument provided to the function.}
\item{bootstrapped.estimates}{the bootstrapped point estimate values, when applicable}
\item{bootstrap.iterations}{the number of iterations used in bootstrapping, when applicable}
\item{method}{refinement method used to create the matched sets from which the estimates were calculated}
\item{lag}{See PanelMatch() argument \code{lag} for more information.}
\item{lead}{The lead window sequence for which \code{PanelEstimate()} is producing point estimates and standard errors.}
\item{confidence.level}{the confidence level}
\item{qoi}{the quantity of interest}
\item{matched.sets}{the refined matched sets used to produce the estimations}
\item{standard.error}{the standard error(s) of the point estimates}
\item{pooled}{Logical indicating whether or not estimates were calculated for individual lead periods or pooled.}
\item{placebo.test}{if \code{include.placebo.test = TRUE}, a placebo test is conducted using \code{placebo_test()} and returned as a list. See documentation for \code{placebo_test()} for more about each individual item.}
}
\description{
\code{PanelEstimate} estimates a causal quantity of interest, including the average treatment effect for
treated or control units (att and atc, respectively), the average effect of treatment reversal on reversed units (art), or average treatment effect (ate), as specified in \code{PanelMatch()}.
This is done by estimating the counterfactual outcomes for each treated unit using
matched sets. Users will provide matched sets that were obtained by the
\code{PanelMatch} function and obtain point estimates via a
weighted average computation with weighted bootstrap standard errors. Point estimates and standard errors will be
produced for each period in the lead window specified by the \code{lead} argument from \code{PanelMatch()}.
Users may run multiple estimations by providing lists of each argument to the function.
However, in this format, every argument must be explicitly specified in each configuration
and must adhere to the same data types/structures outlined below.
}
\examples{
dem.sub <- dem[dem[, "wbcode2"] <= 100, ]
# create subset of data for simplicity
PM.results <- PanelMatch(lag = 4, time.id = "year", unit.id = "wbcode2", 
                        treatment = "dem", refinement.method = "ps.match", 
                         data = dem.sub, match.missing = TRUE, covs.formula = ~ tradewb, 
                         size.match = 5, qoi = "att", outcome.var = "y", 
                         lead = 0:4, forbid.treatment.reversal = TRUE)
PE.results <- PanelEstimate(sets = PM.results, data = dem.sub, se.method = "unconditional")

}
\references{
Imai, Kosuke, In Song Kim, and Erik Wang (2023)
}
\author{
In Song Kim <insong@mit.edu>, Erik Wang
<haixiao@Princeton.edu>, Adam Rauh <amrauh@umich.edu>, and Kosuke Imai <imai@harvard.edu>
}
