% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_downloadLatest.R
\name{monitor_downloadLatest}
\alias{monitor_downloadLatest}
\title{Download recent PM2.5 monitoring data}
\usage{
monitor_downloadLatest(
  parameter = "PM2.5",
  baseUrl = "https://haze.airfire.org/monitoring/latest/RData/",
  dataDir = "~/Data/monitoring/RData",
  ...
)
}
\arguments{
\item{parameter}{Parameter of interest.}

\item{baseUrl}{Base URL for data files.}

\item{dataDir}{Local directory in which to save the data file.}

\item{...}{Additional arguments passed to \code{download.file}.}
}
\description{
Downloads 'latest' data files into \code{dataDir} for later use.
Downloaded versions of PWFSL monitoring .RData files allow users to work with
the package without access to the internet. Once data are downloaded to
\code{dataDir}, any of the data loading functions can be called with the
\code{dataDir} argument to replace internet downloads with local file access.

The recommended directory for PWFSL monitoring data is
\code{"~/data/monitoring/RData"}.

For daily updates covering the most recent 45 days, use \code{monitor_downloadDaily()}.

For data extended more than 45 days into the past, use \code{monitor_downloadAnnual()}.

Currently supported parameters include the following:
\enumerate{
\item{PM2.5}
}

Avaialble RData files can be seen at:
\href{https://haze.airfire.org/monitoring/latest/RData/}{https://haze.airfire.org/monitoring/latest/RData/}
}
\examples{
\donttest{
# Fail gracefully if any resources are not available
try({

library(PWFSLSmoke)

monitor_loadLatest() \%>\%
  monitor_subset(stateCodes=CONUS) \%>\%
  monitor_map()

}, silent = FALSE)
}
}
\seealso{
\code{\link{monitor_loadDaily}}
}
\keyword{AIRSIS}
\keyword{AirNow}
\keyword{WRCC}
