% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeInfo.R
\name{timeInfo}
\alias{timeInfo}
\title{Get Time Related Information}
\usage{
timeInfo(time, longitude = NULL, latitude = NULL, timezone = NULL)
}
\arguments{
\item{time}{POSIXct vector with specified timezone}

\item{longitude}{longitude of the location of interest}

\item{latitude}{latitude of the location of interest}

\item{timezone}{Olson timezone at the location of interest}
}
\value{
A dataframe with times and masks.
}
\description{
Calculate the local time at the target location, sunrise, sunset and solar 
noon times, and create several temporal masks.

If the \code{timezone} is provided it will be used. Otherwise, the \pkg{MazamaSpatialUtils}
package will be used to determine the timezone from \code{longitude} and \code{latitude}.

The returned dataframe will have as many rows as the length of the incoming UTC \code{time} vector
and will contain the following columns:
\itemize{
\item{\code{localTime} -- local clock time}
\item{\code{sunrise} -- time of sunrise on each localTime day}
\item{\code{sunset} -- time of sunset on each localTime day}
\item{\code{solarnoon} -- time of solar noon on each localTime day}
\item{\code{day} -- logical mask = TRUE between sunrise and sunset}
\item{\code{morning} -- logical mask = TRUE between sunrise and solarnoon}
\item{\code{afternoon} -- logical mask = TRUE between solarnoon and sunset}
\item{\code{night} -- logical mask = opposite of day}
}
}
\examples{
carmel <- monitor_subset(Carmel_Valley, tlim=c(20160801,20160810))

# Create timeInfo object for this monitor
ti <- timeInfo(carmel$data$datetime,
               carmel$meta$longitude,
               carmel$meta$latitude,
               carmel$meta$timezone)

# Subset the data based on day/night masks
data_day <- carmel$data[ti$day,]
data_night <- carmel$data[ti$night,]

# Build two monitor objects
carmel_day <- list(meta=carmel$meta, data=data_day)
carmel_night <- list(meta=carmel$meta, data=data_night)

# Plot them
monitorPlot_timeseries(carmel_day, shadedNight=TRUE, pch=8, col='goldenrod')
monitorPlot_timeseries(carmel_night, pch=16, col='darkblue', add=TRUE)
}
