% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitorDygraph.R
\name{monitorDygraph}
\alias{monitorDygraph}
\title{Create Interactive Time Series Plot}
\usage{
monitorDygraph(ws_monitor, title = "title", ylab = "PM2.5 Concentration",
  tlim = NULL, rollPeriod = 1, showLegend = TRUE)
}
\arguments{
\item{ws_monitor}{\emph{ws_monitor} object}

\item{title}{title text}

\item{ylab}{title for the y axis}

\item{tlim}{optional vector with start and end times (integer or character representing YYYYMMDD[HH])}

\item{rollPeriod}{rolling mean to be applied to the data}

\item{showLegend}{logical to toggle display of the legend}
}
\value{
Initiates the interactive dygraph plot in RStudio's 'Viewer' tab.
}
\description{
This function creates interactive graphs that will be displayed in RStudio's 'Viewer' tab.
}
\examples{
\dontrun{
airnow <- airnow_load(20140913, 20141010)
King_Fire <- monitor_subsetByDistance(airnow,
                                      longitude=-120.604,
                                      latitude=38.782,
                                      radius=50)
monitorDygraph(King_Fire, title='KingFire/California/2014', rollPeriod=3)
} 
}
\keyword{ws_monitor}
