% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_dailyStatistic.R
\name{monitor_dailyStatistic}
\alias{monitor_dailyStatistic}
\title{Calculate Daily Statistics for each Monitor in a ws_monitor Object}
\usage{
monitor_dailyStatistic(ws_monitor, FUN = get("mean"), dayStart = "midnight",
  na.rm = TRUE, minHours = 24)
}
\arguments{
\item{ws_monitor}{emph{ws_monitor} object}

\item{FUN}{function used to collapse a day's worth of data into a single number for each monitor in the ws_monitor object}

\item{dayStart}{one of \code{sunset|midnight|sunrise}}

\item{na.rm}{logical value indicating whether NA values should be ignored}

\item{minHours}{minimum number of valid data hours required to calculate each daily statistic}
}
\value{
A emph{ws_monitor} object with daily statistics for the local timezone.
}
\description{
Calculates daily statistics for each monitor in \code{ws_monitor}.
}
\details{
Sunrise and sunset times are calculated based on the first monitor encountered.
This should be accurate enough for all use cases involving co-located monitors. Monitors
from different regions should have daily statistics calculated separately.
}
\note{
Note that the incoming \emph{ws_monitor} object should have UTC (GMT)
times and that this function calculates daily statistics based on local (clock) time.
If you choose a date range based on UTC times this may result in an insufficient 
number of hours in the first and last daily records of the returned \emph{ws_monitor}
object.

The returned \emph{ws_monitor} object has a daily time axis where each time is set to 00:00, local time.
}
\examples{
N_M <- monitor_subset(Northwest_Megafires, tlim=c(20150801,20150831))
Twisp <- monitor_subset(N_M, tlim=c(20150801,20150831), monitorIDs='530470009')
Twisp_dailyMean <- monitor_dailyStatistic(Twisp, FUN=get('mean'), dayStart='midnight')
monitorPlot_timeseries(Twisp_dailyMean, type='b')
addAQILines()
addAQILegend("topleft", lwd=1, pch=NULL)
title("Twisp, Washington Daily Mean PM2.5, 2015")
}
\keyword{ws_monitor}

