% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aranovichanalysis.R
\name{aranovichanalysis}
\alias{aranovichanalysis}
\title{Aranovich Isotherm Non-Linear Analysis}
\usage{
aranovichanalysis(Ce, Qe)
}
\arguments{
\item{Ce}{the numerical value for the equilibrium capacity}

\item{Qe}{the numerical value for the adsorbed capacity}
}
\value{
the nonlinear regression, parameters for Aranovich isotherm,
and model error analysis
}
\description{
The Aranovich isotherm (Aranovich, 1992) is a three-parameter
isotherm model that is a modified version of the BET isotherm. This isotherm
model is theoretically corrected by polymolecular adsorption isotherm and is
applicable to modeling adsorption with a wide range concentration of the
adsorbate molecules.
}
\examples{
Ce <- c(0.01353, 0.04648, 0.13239, 0.27714, 0.41600, 0.63607, 0.80435, 1.10327, 1.58223)
Qe <- c(0.03409, 0.06025, 0.10622, 0.12842, 0.15299, 0.15379, 0.15735, 0.15735, 0.16607)
aranovichanalysis(Ce,Qe)
}
\references{
Aranovich, G. L. (1992) <doi:10.1021/la00038a071> The Theory of Polymolecular Adsorption.
Langmuir, 8(2), 736-739.
}
\author{
Paul Angelo C. Manlapaz

Chester C. Deocaris
}
