% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dubininradushkevichLM.R
\name{dubininraduskevich.LM}
\alias{dubininraduskevich.LM}
\alias{dubininradushkevich.LM}
\title{Dubinin-Radushkevich Isotherm  Linear Analysis}
\usage{
dubininradushkevich.LM(Ce, Qe, Temp)
}
\arguments{
\item{Ce}{the numerical value for the equilibrium capacity}

\item{Qe}{the numerical value for the adsorbed capacity}

\item{Temp}{temperature}
}
\value{
the linear regression, parameters for Dubinin-Radushkevich isotherm,
and model error analysis
}
\description{
Dubinin-Radushkevich isotherm model is being utilized to define
adsorption energy mechanisms with Gaussian distribution onto heterogeneous surfaces.
Specifically, this model works well with an intermediate range of adsorbate
concentrations because it shows abnormal asymptotic behavior and is unable to
forecast Henry's Law at low pressure.
}
\examples{
Ce <- c(0.01353, 0.04648, 0.13239, 0.27714, 0.41600, 0.63607, 0.80435, 1.10327, 1.58223)
Qe <- c(0.03409, 0.06025, 0.10622, 0.12842, 0.15299, 0.15379, 0.15735, 0.15735, 0.16607)
Temp <- 298
dubininradushkevich.LM (Ce,Qe,Temp)
}
\references{
Dubinin, M.M. and Radushkevich, L.V. (1947) The Equation of the
Characteristic Curve of Activated Charcoal.
Proceedings of the Academy of Sciences, Physical Chemistry Section, 55, 331.

Foo, K. Y., &amp; Hameed, B. H. (2009, September 13).
<doi:10.1016/j.cej.2009.09.013> Insights into the modeling of adsorption isotherm
systems. Chemical Engineering Journal.
}
\author{
Jemimah Christine L. Mesias

Chester C. Deocaris
}
