\name{bal.ms.psa}
\alias{bal.ms.psa}
\title{Balance for Continuous Covariate: Random Strata as part of a PSA }
\description{Function provides a measure (based on the trimmed mean) of the balance achieved between control and treatment 
groups for a continuous covariate from user defined strata. This statistic is compared to the same measure 
for randomly permuted strata.
}
\usage{
bal.ms.psa(continuous, treatment = NULL, strata = NULL, 
trim = 0, B = 1000, main = NULL)
}
\arguments{
  \item{continuous}{Quantitative covariate that is being balanced within strata in a PSA. 
    If \code{continuous} has three columns, then the second and third are assumed to 
    be the treatment and strata respectively.  Missing values are not allowed. }
  \item{treatment}{Binary variable of same length as \code{continuous}; generally 0 for 'control,' 1 for 'treatment.' }
  \item{strata}{Integer variable;  a vector of same length as \code{continuous} indicating the 
    derived strata from estimated propensity scores.}
  \item{trim}{Fraction (0 to 0.5) of observations to be trimmed from each end of stratum-treatment 
    level before the mean is computed. See \code{\link{mean}}.}
  \item{B}{Numeric; number of randomly generated iterations of the balance 
    measure are created for the comparison distribution.}
  \item{main}{Title passed to \code{histogram}.}
}
\details{This function measures the balance achieved across K strata for a continuous covariate.  
If \eqn{ \mu_{ik} } is the covariate trimmed (as specified by user) mean of cases in stratum k, treatment i, 
then the statistic is the sum over all K of \eqn{ |\mu_{0k} - \mu_{1k}| }.  A permutation distribution 
is generated by randomly assigning cases to strata, thus generating B permuted stratifications and the associated B permutation statistics. 
The permutation stratifications are generated under a fixed marginals model to retain comparability with the original stratification. 
A histogram of the permutation statistics is produced with the original statistic referenced as a red dot.

}
\value{In addition to the histogram, a list with the following components is returned:
  \item{balance.orig }{Balance measure of user defined strata.}
  \item{rank.orig}{Rank of original balance measure in comparison 
  with the B randomly generated values.}
  }
\author{James E. Helmreich \email{ James.Helmreich@Marist.edu}

 Robert M. Pruzek \email{RMPruzek@yahoo.com}}
\seealso{ \code{bal.ks.psa}, \code{bal.cws.psa}, \code{bal.cs.psa} }
\examples{#Balance stat should be close to zero
meas<-rnorm(500)
continuous<-c(meas,meas+rnorm(500,0,.1))
treatment<-c(rep(0,500),rep(1,500))
strata<-rep(c(rep(1,100),rep(2,100),rep(3,100),rep(4,100),rep(5,100)),2)
bal.ms.psa(continuous,treatment,strata)


#Balance stat should be close to .4
meas<-rnorm(500)
continuous<-c(meas, meas[1:250] + runif(250,0,.2), 
   meas[251:500]-runif(250,0,.2))
treatment<-c(rep(0,500),rep(1,500))
strata<-rep(c(rep(1,100), rep(2,100), rep(3,100), 
   rep(4,100),rep(5,100)),2)
bal.ms.psa(continuous, treatment, strata, B=200)
}
\keyword{ htest }
