\name{loadPrismaData}
\alias{loadPrismaData}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
  Load PRISMA Data Files
}
\description{
  Loads files generated by the sally tool (see
  http://www.mlsec.org/sally/) and represents the data as binary
  token/ngrams x documents matrix. After loading statistical tests are
  applied to find features, which are not volatile nor
  constant. Co-occurring features are grouped to further compactify the
  data. See system.file("extdata","sallyPreprocessing.py",
  package="PRISMA") for a Python script which generates the
  corresponding .fsally file from a .sally file which increases the
  loading time via loadPrismaData.
}
\usage{
loadPrismaData(path, maxLines = -1, fastSally = TRUE, alpha = 0.05)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{path}{
    path of the data file without the .sally extension. loadPrisma loads
    path.sally or path.fsally depending on the fastSally switch.
}
  \item{maxLines}{
    maximal number of lines to read from the data file. -1 means to read
    all lines.
}
  \item{fastSally}{
    should the fsally file be used, which drastically increases loading time.
}
  \item{alpha}{
    significance level for the feature tests.
}
}
\value{
  \item{prismaData}{data object representing the tokenized documents as
    features x samples matrix.}
}
\references{
  See http://www.mlsec.org/sally/ for the sally utility.
}
\author{
Tammo Krueger <t.krueger@tu-berlin.de>
}
\examples{
# please extract system.file("extdata","asap.tar.gz", package="PRISMA")
# before running this example
\donttest{asap = loadPrismaData(system.file("extdata","asap", package="PRISMA"))}
}
