% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popdemog.R
\name{NRuler}
\alias{NRuler}
\title{Add population size ruler}
\usage{
NRuler(x, y = NULL, Nsize, Nlab = Nsize, N4, size.scale,
  linear.scale = 0.2, log.base = 10, ...)
}
\arguments{
\item{x, y}{Position of the population size ruler. If y does not have numeric value, x will support keyword input from the list "bottomright", "bottom", "bottomleft","left", "topleft", "top", "topright", "right" and "center".}

\item{Nsize}{The population sizes of the ticks on the ruler.}

\item{Nlab}{The labels on the ticks of the ruler. Default labels are the population index.}

\item{N4}{Scalar to scale population size.}

\item{size.scale}{A keyword to define the way population size is scaled and displayed. It supports "log" and "linear".}

\item{linear.scale}{The scale factor applied to the population size when \code{size.scale} = "linear".}

\item{log.base}{The base of logarithm used when \code{size.scale} = "log".}

\item{...}{Additional arguments can be passed, such as \code{col}, \code{lwd}, \code{lty}.}
}
\description{
Adds a ruler for the population size. This function works like the function \code{legend},
}
