% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/point.R
\name{point}
\alias{point}
\title{Protein Structure Guided Local Test}
\usage{
point(yy, X, snp, proteinCoord, ..., trait = "binomial", cValues = c(0,
  0.1, 0.2, 0.3, 0.4, 0.5), weighted = TRUE, weight = NULL,
  kernel = "linear", d = NULL, pvMethod = "davies",
  nperturb = 1000, verbose = TRUE)
}
\arguments{
\item{yy}{numeric vector; phenotype values.}

\item{X}{numeric matrix; non-genetic covariates.}

\item{snp}{numeric matrix; genotype snp matrix (count of minor alleles).
Matrix cannot contain missing values.}

\item{proteinCoord}{numeric matrix; columns correspond to 3 dimensional
coordinates (x,y,z) of each variant in the protein tertiary structure.}

\item{...}{optional additional arguments for p-value methods 
CompQuadForm::davies and CompQuadForm::liu.}

\item{trait}{character; type of phenotype data.
Must be one of \{'gaussian','binomial'\}
quantitative or case control data, respectively.}

\item{cValues}{numeric vector; c values from which to choose the
optimal neighborhood size for borrowing significant information.}

\item{weighted}{logical; whether or not to weight the local kernel
test using (non-distance based) weights.}

\item{weight}{numeric vector (optional) If NULL and weighted is TRUE
(1.0-MAF)^24. Ignored if weighted is FALSE.}

\item{kernel}{character; type of local kernel to use;
Must be one of \{'burden', 'linear', 'polynomial'\}.}

\item{d}{numeric; If kernel = 'poly', d is the order of the
polynomial kernel.}

\item{pvMethod}{character; method of calculating the p-value of each
single marker test for fixed c values.
Must be one of \{'davies', 'liu'\}.}

\item{nperturb}{numeric, number of perturbations/resamples
(perturbed test statistics) to calculate p-value of minP statistic.}

\item{verbose}{logical; generate progress screen prints.}
}
\value{
Returns a matrix the rows of which correspond to individual markers.
  Columns correspond to: \cr 
  (1) minP statistic; \cr 
  (2) local kernel test p-value; \cr
  (3) optimal scale value from input cValues; \cr
  (4) minor allele frequency; and \cr
  (5) single variant score test p-value.
}
\description{
A rare variant association test that utilizes protein tertiary structure to 
  increase signal and to identify likely causal variants. Performs 
  structure-guided collapsing, which leads to local tests that borrow 
  information from neighboring variants on a protein and that provide 
  association information on a variant-specific level.
}
\examples{

  # number of subjects
  nsubj <- 1000

  # number of markers
  nm <- 5

  # generate coordinates for proteins
  protein <- cbind( stats::rnorm(n = nm, mean = 17.6, sd =  6.6),
                    stats::rnorm(n = nm, mean =  1.6, sd = 13.6),
                    stats::rnorm(n = nm, mean = 22.9, sd = 10.4) )

  # generate snp matrix
  snp <- matrix(data = rbinom(n = nsubj*nm, size = 1, p = 0.02), 
                nrow = nsubj, ncol = nm)
  colnames(snp) = paste0("m",1:nm)

  # generate binmoial response
  MAF <- colMeans(x = snp)/2
  causal <- numeric(nm)
  causal[c(2,4)] <- 1.0
  betaG <- 0.4*abs(log10(x = MAF))*causal

  #no non-genetic covariates
  X <- NULL
  mu <- -0.05 + snp \\\%*\\\% betaG

  pryy <- exp(mu)/(1+exp(mu))
  yy <- sapply(X = pryy, FUN = stats::rbinom, n = 1, size = 1)

  res <- point(yy = yy, X = X, snp = snp, proteinCoord = protein,
               trait = 'binomial', cValues = c(0.1,0.2),
               weighted = TRUE, weight = NULL, kernel = 'linear',
               pvMethod = 'liu', nperturb = 100,
               verbose = FALSE)

}
