% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pof.R
\name{get_pof}
\alias{get_pof}
\title{Download, label, deflate and create survey design object for POF microdata}
\usage{
get_pof(
  year,
  selected = FALSE,
  anthropometry = FALSE,
  vars = NULL,
  labels = TRUE,
  deflator = TRUE,
  design = TRUE,
  savedir = tempdir()
)
}
\arguments{
\item{year}{The year of the data to be downloaded. Must be a number equal to 2008 or 2017. Vector not accepted.}

\item{selected}{Logical value. If \code{TRUE}, the specific questionnaire for selected resident will be used. If \code{FALSE}, the basic questionnaire for household and residents will be used.}

\item{anthropometry}{Logical value. If \code{TRUE}, the specific questionnaire for the anthropometry module of the selected resident will be used. If \code{FALSE}, the questionnaire defined by the argument \code{selected} of this function will be used. This argument will be used only if \code{year} is equal to 2017.}

\item{vars}{Vector of variable names to be kept for analysis. Default is to keep all variables.}

\item{labels}{Logical value. If \code{TRUE}, categorical variables will presented as factors with labels corresponding to the survey's dictionary.}

\item{deflator}{Logical value. If \code{TRUE}, deflator variable will be available for use in the microdata.}

\item{design}{Logical value. If \code{TRUE}, will return an object of class \code{survey.design}. It is strongly recommended to keep this parameter as \code{TRUE} for further analysis. If \code{FALSE}, only the microdata will be returned.}

\item{savedir}{Directory to save the downloaded data. Default is to use a temporary directory.}
}
\value{
An object of class \code{survey.design} with the data from POF and its sample design, or a tibble with selected variables of the microdata, including the necessary survey design ones.
}
\description{
Core function of package. With this function only, the user can download a POF microdata from a year and get a sample design object ready to use with \code{survey} package functions.
}
\note{
For more information, visit the survey official website <\url{https://www.ibge.gov.br/estatisticas/sociais/trabalho/9050-pesquisa-de-orcamentos-familiares.html?=&t=o-que-e}> and consult the other functions of this package, described below.
}
\examples{
\donttest{
pof.svy <- get_pof(year=2017, selected=FALSE, anthropometry=FALSE, vars=c("V0407","V0408"),
                       labels=TRUE, deflator=TRUE, design=TRUE, savedir=tempdir())
# Calculating proportion of people's purchase of goods or services
if (!is.null(pof.svy)) survey::svymean(x=~V0408, design=pof.svy, na.rm=TRUE)
pof.svy2 <- get_pof(year=2017, selected=TRUE, anthropometry=FALSE, vars=c("V4104","V4105"),
                       labels=TRUE, deflator=TRUE, design=TRUE, savedir=tempdir())
# Calculating proportion of reasons for non-routine trips indicated by people
if (!is.null(pof.svy2)) survey::svymean(x=~V4104, design=pof.svy2, na.rm=TRUE)
pof.svy3 <- get_pof(year=2017, selected=FALSE, anthropometry=TRUE, vars=c("V7102","V7104"),
                       labels=TRUE, deflator=TRUE, design=TRUE, savedir=tempdir())
# Calculating proportion of people who followed some type of diet
if (!is.null(pof.svy3)) survey::svymean(x=~V7104, design=pof.svy3, na.rm=TRUE)}
}
\seealso{
\link[POFIBGE]{read_pof} for reading POF microdata.\cr \link[POFIBGE]{pof_labeller} for labelling categorical variables from POF microdata.\cr \link[POFIBGE]{pof_deflator} for adding deflator variable to POF microdata.\cr \link[POFIBGE]{pof_design} for creating POF survey design object.\cr \link[POFIBGE]{pof_example} for getting the path of the POF example files.
}
