% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pharmonic.R
\name{pharmonic}
\alias{pharmonic}
\title{Harmonic analysis test: p-value calculation}
\usage{
pharmonic(n, r, g)
}
\arguments{
\item{n}{the total number of frequencies in FFT results}

\item{r}{the modulus of the tested frequency is ranked as the rth largest among all frequencies}

\item{g}{the FFT result of the tested frequency expressed as the squared modulus divided by the sum of the squared moduli by all frequencies (proportion: m_r^2/(m_1^2+...+m_n^2)).}
}
\value{
The p-value calculated by the harmonic test.
}
\description{
This function calculates the p-value for the harmonic analysis test developed by R.A. Fisher (1929). Harmonic analysis specifically refers to Fast Fourier Transform (FFT) results.
}
\examples{
pharmonic(n=100,r=2,g=0.1)

}
\references{
Fisher, R. A. (1929). Tests of significance in harmonic analysis. Proceedings of the Royal Society of London. Series A, 125(796), 54-59.
}
\seealso{
\code{\link{gharmonic}}
}
\keyword{harmonic}
\keyword{test}
