% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frdHouseTest.R
\name{frdHouseTest}
\alias{frdHouseTest}
\alias{frdHouseTest.default}
\title{House Test}
\usage{
frdHouseTest(y, ...)

\method{frdHouseTest}{default}(y, groups, blocks, alternative = c("greater", "less"), ...)
}
\arguments{
\item{y}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{groups}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}. Ignored with a warning if \code{"x"} is a list.}

\item{blocks}{a vector or factor object giving the block for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{alternative}{the alternative hypothesis. Defaults to \code{greater}.}

\item{\ldots}{further arguments to be passed to or from methods.}
}
\value{
A list with class \code{"PMCMR"} containing the following components:
\describe{
\item{method}{a character string indicating what type of test was performed.}
\item{data.name}{a character string giving the name(s) of the data.}
\item{statistic}{lower-triangle matrix of the estimated
quantiles of the pairwise test statistics.}
\item{p.value}{lower-triangle matrix of the p-values for the pairwise tests.}
\item{alternative}{a character string describing the alternative hypothesis.}
\item{p.adjust.method}{a character string describing the method for p-value
adjustment.}
\item{model}{a data frame of the input data.}
\item{dist}{a string that denotes the test distribution.}
}
}
\description{
Performs House nonparametric equivalent of William's test
for contrasting increasing dose levels of a treatment in
a complete randomized block design.
}
\details{
House test is a non-parametric step-down trend test for testing several treatment levels
with a zero control. Let there be \eqn{k} groups including the control and let
the zero dose level be indicated with \eqn{i = 0} and the highest
dose level with \eqn{i = m}, then the following \code{m = k - 1} hypotheses are tested:

\deqn{
\begin{array}{ll}
\mathrm{H}_{m}: \theta_0 = \theta_1 = \ldots = \theta_m, & \mathrm{A}_{m} = \theta_0 \le \theta_1 \le \ldots \theta_m, \theta_0 < \theta_m \\
\mathrm{H}_{m-1}: \theta_0 = \theta_1 = \ldots = \theta_{m-1}, & \mathrm{A}_{m-1} = \theta_0 \le \theta_1 \le \ldots \theta_{m-1}, \theta_0 < \theta_{m-1} \\
\vdots & \vdots \\
\mathrm{H}_{1}: \theta_0 = \theta_1, & \mathrm{A}_{1} = \theta_0 < \theta_1\\
\end{array}
}

Let \eqn{Y_{ij} ~ (1 \leq i \leq n, 0 \leq j \leq k)} be a i.i.d. random variable
of at least ordinal scale. Further, let \eqn{\bar{R}_0,~\bar{R}_1, \ldots,~\bar{R}_k}
be Friedman's average ranks and set \eqn{\bar{R}_0^*, \leq \ldots \leq \bar{R}_k^*}
to be its isotonic regression estimators under the order restriction
\eqn{\theta_0 \leq \ldots \leq \theta_k}.

The statistics is
\deqn{
T_j = \left(\bar{R}_j^* - \bar{R}_0 \right)~ \left[ \left(V_j - H_j \right)
\left(2 / n \right) \right]^{-1/2} \qquad (1 \leq j \leq k),
}

with
\deqn{
V_j = \left(j + 1\right) ~ \left(j + 2 \right) / 12
}

and
\deqn{
H_j = \left(t^3 - t \right) / \left(12 j n \right),
}

where \eqn{t} is the number of tied ranks.

The critical \eqn{t'_{i,v,\alpha}}-values
as given in the tables of Williams (1972) for \eqn{\alpha = 0.05} (one-sided)
are looked up according to the degree of freedoms (\eqn{v = \infty}) and the order number of the
dose level (\eqn{j}).

For the comparison of the first dose level \eqn{(j = 1)} with the control, the critical
z-value from the standard normal distribution is used (\code{\link[stats]{Normal}}).
}
\examples{
 ## Sachs, 1997, p. 675
 ## Six persons (block) received six different diuretics
 ## (A to F, treatment).
 ## The responses are the Na-concentration (mval)
 ## in the urine measured 2 hours after each treatment.
 ## Assume A is the control.

 y <- matrix(c(
 3.88, 5.64, 5.76, 4.25, 5.91, 4.33, 30.58, 30.14, 16.92,
 23.19, 26.74, 10.91, 25.24, 33.52, 25.45, 18.85, 20.45,
 26.67, 4.44, 7.94, 4.04, 4.4, 4.23, 4.36, 29.41, 30.72,
 32.92, 28.23, 23.35, 12, 38.87, 33.12, 39.15, 28.06, 38.23,
 26.65),nrow=6, ncol=6,
 dimnames=list(1:6, LETTERS[1:6]))

 ## Global Friedman test
 friedmanTest(y)

 ## Demsar's many-one test
 summary(frdManyOneDemsarTest(y=y, p.adjust = "bonferroni",
                      alternative = "greater"))

 ## Exact many-one test
 summary(frdManyOneExactTest(y=y, p.adjust = "bonferroni",
                     alternative = "greater"))

 ## Nemenyi's many-one test
 summary(frdManyOneNemenyiTest(y=y, alternative = "greater"))

 ## House test
 frdHouseTest(y, alternative = "greater")

}
\references{
Chen, Y.-I., 1999. Rank-Based Tests for Dose Finding in
Nonmonotonic Dose–Response Settings.
\emph{Biometrics} \strong{55}, 1258--1262. \doi{10.1111/j.0006-341X.1999.01258.x}

House, D.E., 1986. A Nonparametric Version of Williams’ Test for
Randomized Block Design. \emph{Biometrics} \strong{42}, 187--190.
}
\seealso{
\code{\link{friedmanTest}}, \code{\link[stats]{friedman.test}},
\code{\link{frdManyOneExactTest}}, \code{\link{frdManyOneDemsarTest}}
}
\concept{friedmanranks}
\keyword{htest}
\keyword{nonparametric}
