% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cochran.R
\name{Cochran}
\alias{Cochran}
\alias{qcochran}
\alias{pcochran}
\title{Cochran's distribution}
\usage{
qcochran(p, k, n, lower.tail = TRUE, log.p = FALSE)

pcochran(q, k, n, lower.tail = TRUE, log.p = FALSE)
}
\arguments{
\item{p}{vector of probabilities.}

\item{k}{number of groups.}

\item{n}{(average) sample size of the k groups.}

\item{lower.tail}{logical; if TRUE (default),
probabilities are \eqn{P[X \leq x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{q}{vector of quantiles.}
}
\value{
\code{pcochran} gives the distribution function and
\code{qcochran} gives the quantile function.
}
\description{
Distribution function and quantile function
for Cochran's distribution.
}
\examples{
qcochran(0.05, 7, 3)
}
\references{
Cochran, W.G. (1941) The distribution of the largest of a set of estimated
variances as a fraction of their total. \emph{Ann. Eugen.} \bold{11}, 47--52.

Wilrich, P.-T. (2011) Critical values of Mandel's h and k,
Grubbs and the Cochran test statistic. \emph{Adv. Stat. Anal.}.
\doi{10.1007/s10182-011-0185-y}.
}
\seealso{
\code{\link{FDist}}
}
\keyword{distribution}
