% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dgrubbs.R
\name{Dgrubbs}
\alias{Dgrubbs}
\alias{pdgrubbs}
\title{Grubbs D* distribution}
\usage{
pdgrubbs(q, n, m = 10000, lower.tail = TRUE, log.p = FALSE)
}
\arguments{
\item{q}{vector of quantiles.}

\item{n}{total sample size.}

\item{m}{number of Monte-Carlo replicates. Defaults to \code{10,000}.}

\item{lower.tail}{logical; if TRUE (default), probabilities are P[X <= x]
otherwise, P[X > x].}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}
}
\value{
\code{pgrubbs} gives the distribution function
}
\description{
Distribution function for Grubbs D* distribution.
}
\examples{
pdgrubbs(0.62, 7, 1E4)
}
\references{
Grubbs, F.E. (1950) Sample criteria for testing outlying observations,
\emph{Ann. Math. Stat.} \bold{21}, 27--58.

Wilrich, P.-T. (2011) Critical values of Mandel's h and k,
Grubbs and the Cochran test statistic, \emph{Adv. Stat. Anal.}.
\doi{10.1007/s10182-011-0185-y}.
}
\seealso{
\code{\link{Grubbs}}
}
\keyword{distribution}
