% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/siegelTukeyTest.R
\name{siegelTukeyTest}
\alias{siegelTukeyTest}
\alias{siegelTukeyTest.default}
\alias{siegelTukeyTest.formula}
\title{Siegel-Tukey Rank Dispersion Test}
\source{
The algorithm for the Siegel-Tukey ranks was
taken from the code of Daniel Malter. See also the
blog from Tal Galili (02/2010, \url{https://www.r-statistics.com/2010/02/siegel-tukey-a-non-parametric-test-for-equality-in-variability-r-code/},
accessed 2018-08-05).
}
\usage{
siegelTukeyTest(x, ...)

\method{siegelTukeyTest}{default}(
  x,
  y,
  alternative = c("two.sided", "greater", "less"),
  median.corr = FALSE,
  ...
)

\method{siegelTukeyTest}{formula}(formula, data, subset, na.action, ...)
}
\arguments{
\item{x, y}{numeric vectors of data values.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{alternative}{a character string specifying the
alternative hypothesis, must be one of \code{"two.sided"} (default),
\code{"greater"} or \code{"less"}.
You can specify just the initial letter.}

\item{median.corr}{logical indicator, whether median correction
should be performed prior testing. Defaults to \code{FALSE}.}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a 
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
A list with class \code{"htest"} containing the following components:
\describe{
 \item{method}{a character string indicating what type of test was performed.}
 \item{data.name}{a character string giving the name(s) of the data.}
 \item{statistic}{the estimated quantile of the test statistic.}
 \item{p.value}{the p-value for the test.}
 \item{parameter}{the parameters of the test statistic, if any.}
 \item{alternative}{a character string describing the alternative hypothesis.}
\item{estimates}{the estimates, if any.}
\item{null.value}{the estimate under the null hypothesis, if any.}
}
}
\description{
Performs Siegel-Tukey non-parametric
rank dispersion test.
}
\details{
Let \eqn{x} and \eqn{y} denote two identically and indepentently
distributed variables of at least ordinal scale.
 Further, let
 \eqn{\theta}{theta}, and \eqn{\lambda}{lambda} denote
 location and scale parameter of the common, but unknown distribution.
 Then for the two-tailed case, the null hypothesis
 H: \eqn{\lambda_x / \lambda_y = 1 | \theta_x = \theta_y}{%
 lambdaX / lambdaY = 1 | thetaX = thetaY} is
 tested against the alternative,
 A: \eqn{\lambda_x / \lambda_y \ne 1}{lambdaX / lambdaY != 1}.

 The data are combinedly ranked according to Siegel-Tukey.
 The ranking is done by alternate extremes (rank 1 is lowest,
 2 and 3 are the two highest, 4 and 5 are the two next lowest, etc.).
 If no ties are present, the p-values are computed from
 the Wilcoxon distribution (see \code{\link{Wilcoxon}}).
 In the case of ties, a tie correction is done according
 to Sachs (1997) and approximate p-values are computed
 from the standard normal distribution (see \code{\link{Normal}}).

 If both medians differ, one can correct for medians to
increase the specificity of the test.
}
\examples{
## Sachs, 1997, p. 376
A <- c(10.1, 7.3, 12.6, 2.4, 6.1, 8.5, 8.8, 9.4, 10.1, 9.8)
B <- c(15.3, 3.6, 16.5, 2.9, 3.3, 4.2, 4.9, 7.3, 11.7, 13.7)
siegelTukeyTest(A, B)

## from example var.test
x <- rnorm(50, mean = 0, sd = 2)
y <- rnorm(30, mean = 1, sd = 1)
siegelTukeyTest(x, y, median.corr = TRUE)

## directional hypothesis
A <- c(33, 62, 84, 85, 88, 93, 97)
B <- c(4, 16, 48, 51, 66, 98)
siegelTukeyTest(A, B, alternative = "greater")

}
\references{
Sachs, L. (1997), \emph{Angewandte Statistik}. Berlin: Springer.

Siegel, S., Tukey, J. W. (1960), A nonparametric sum of ranks
procedure for relative spread in unpaired samples,
\emph{Journal of the American Statistical Association} \bold{55}, 429--455.
}
\keyword{htest}
\keyword{nonparametric}
