% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sample_classification.R
\name{get_sam_cla}
\alias{get_sam_cla}
\title{get_sam_cla}
\usage{
get_sam_cla(
  mut_sam,
  gene_Ucox,
  symbol_Entrez,
  path_cox_data,
  sur,
  path_Ucox_mul,
  sig,
  cut_off = -0.986,
  data.dir = NULL,
  organism = "hsa",
  TRAIN = FALSE
)
}
\arguments{
\item{mut_sam}{The sample somatic mutation data.}

\item{gene_Ucox}{Results of gene univariate Cox regression.}

\item{symbol_Entrez}{A data table containing gene symbol and gene Entrez ID.}

\item{path_cox_data}{Pathways of Cancer-specifical obtained from the training set.}

\item{sur}{This data contains survival status and survival time of each sample.}

\item{path_Ucox_mul}{Multivariate Cox regression results of  Cancer-specifical pathways.}

\item{sig}{Cancer-specific dysregulated signal pathways. It can be generated by the function `get_final_signature`.}

\item{cut_off}{Threshold of classification.}

\item{data.dir}{Location of the "organism"SPIA.RData file containing the pathways data. If set to NULL will look for this file in the extdata folder of the PMAPscore library.}

\item{organism}{A three letter character designating the organism. See a full list at ftp://ftp.genome.jp/pub/kegg/xml/organisms.}

\item{TRAIN}{Logical,if set FLASE,we need to load the result of multivariate Cox regression of cancer specific pathways into the training set.}
}
\value{
Return a data frame, the sample's risk score and the sample's risk group.
}
\description{
Function `get_sample_classification` This function is used to judge the classification of samples.
}
\examples{
#Load the data.
data(mut_sam,gene_Ucox,symbol_Entrez,path_cox_data,sur,path_Ucox_mul)
#perform function `get_sample_cla`.
\donttest{get_sam_cla(mut_sam,gene_Ucox,symbol_Entrez,path_cox_data,sur,path_Ucox_mul,sig,cut_off=-0.986)}
}
