% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_roc_curve.R
\name{get_roc_curve}
\alias{get_roc_curve}
\title{Plot the ROC curve}
\usage{
get_roc_curve(roc_data, print.auc = TRUE, main = "Objective Response")
}
\arguments{
\item{roc_data}{A 2 X n data fram, which contain the immunotherapy response and risk score (generated by the function `get_risk_score`) for patients.}

\item{print.auc}{Boolean. Should the numeric value of AUC be printed on the plot?}

\item{main}{A main title for the plot.}
}
\value{
No return, plot the ROC curve for immunotherapy response prediction.
}
\description{
The function `get_roc_curve` uses to plot the ROC curve for predicting immunotherapy response.
}
\examples{
#Load the data.
data(roc_data)
#perform the function `get_roc_curve`.
get_roc_curve(roc_data,print.auc=TRUE,main="Objective Response")
}
