% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_final_signature.R
\name{get_final_signature}
\alias{get_final_signature}
\title{Identify the candidate prognosis-related pathways}
\usage{
get_final_signature(pfs_score, sur, wilcox_p = 0.05, uni_cox_p = 0.01)
}
\arguments{
\item{pfs_score}{A 2 X n matrix that contains the pfs_score in each sample of the signal pathways. Noted the matrix can be generated by the function `get_pfs_score`.}

\item{sur}{This data contains survival status and survival time of each sample.}

\item{wilcox_p}{The threshold of p value for Wilcoxon rank-sum test.}

\item{uni_cox_p}{The threshold of p value for univariate Cox regression analysis.}
}
\value{
Return the candidate prognosis-related pathways
}
\description{
The function `get_final_signature` uses to identify the candidate prognosis-related pathways based on the PMAPscore.
}
\examples{
#load the data.
data(pfs_score,sur)
#perform function `get_final_signature`.
final_signature<-get_final_signature(pfs_score,sur)
}
